/*
 * Decompiled with CFR 0.152.
 */
package uk.org.retep.util.io;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Collection;

public abstract class LogicFileFilter
extends ArrayList<FileFilter>
implements FileFilter {
    protected LogicFileFilter() {
    }

    protected LogicFileFilter(FileFilter ... filters) {
        this.add(filters);
    }

    protected LogicFileFilter(Collection<? extends FileFilter> filters) {
        super(filters);
    }

    public void add(FileFilter ... filters) {
        for (FileFilter filter : filters) {
            this.add(filter);
        }
    }

    public static class Not
    implements FileFilter {
        private final FileFilter filter;

        public Not(FileFilter filter) {
            this.filter = filter;
        }

        @Override
        public boolean accept(File file) {
            return !this.filter.accept(file);
        }
    }

    public static class Or
    extends LogicFileFilter {
        public Or() {
        }

        public Or(FileFilter ... filters) {
            this.add(filters);
        }

        public Or(Collection<? extends FileFilter> filters) {
            super(filters);
        }

        @Override
        public boolean accept(File file) {
            for (FileFilter filter : this) {
                if (!filter.accept(file)) continue;
                return true;
            }
            return false;
        }
    }

    public static class And
    extends LogicFileFilter {
        public And() {
        }

        public And(FileFilter ... filters) {
            this.add(filters);
        }

        public And(Collection<? extends FileFilter> filters) {
            super(filters);
        }

        @Override
        public boolean accept(File file) {
            for (FileFilter filter : this) {
                if (filter.accept(file)) continue;
                return false;
            }
            return true;
        }
    }
}

