/*
 * Decompiled with CFR 0.152.
 */
package uk.org.retep.util.graphics;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import uk.org.retep.swing.model.EnumModel;
import uk.org.retep.util.graphics.GeomUtils;
import uk.org.retep.util.graphics.JoinEnd;
import uk.org.retep.util.graphics.Orientation;
import uk.org.retep.util.string.StringUtils;

public enum Join implements EnumModel.Renderable
{
    CUBIC(0),
    QUAD(0),
    STRAIGHT(0),
    DIRECT(0),
    CUBIC_DASHED(1),
    QUAD_DASHED(1),
    STRAIGHT_DASHED(1),
    DIRECT_DASHED(1),
    CUBIC_DOTTED(2),
    QUAD_DOTTED(2),
    STRAIGHT_DOTTED(2),
    DIRECT_DOTTED(2);

    private int mode;
    private boolean fillable;

    private Join(int mode) {
        this.mode = mode;
        this.fillable = mode == 0;
    }

    public final void draw(Graphics g, Orientation orientation, boolean bottom, Shape fromShape, JoinEnd fromJoin, Shape toShape, JoinEnd toJoin) {
        double x3;
        double x4;
        double x1;
        double x2;
        double y2;
        double y3;
        double y4;
        double y1;
        Rectangle from = fromShape.getBounds();
        Rectangle to = toShape.getBounds();
        Point2D fc = GeomUtils.getCentre(fromShape);
        Point2D tc = GeomUtils.getCentre(toShape);
        if (bottom) {
            switch (orientation) {
                case FLIP_VERTICAL: 
                case INVERTED: {
                    y1 = from.getY();
                    y4 = to.getY() + to.getHeight();
                    y2 = y3 = y4 + (y1 - y4) / 2.0;
                    break;
                }
                default: {
                    y1 = from.getY() + from.getHeight();
                    y4 = to.getY();
                    y2 = y3 = y1 + (y4 - y1) / 2.0;
                }
            }
            x1 = x2 = fc.getX();
            x3 = x4 = tc.getX();
        } else {
            switch (orientation) {
                case INVERTED: 
                case FLIP_HORIZONTAL: {
                    x1 = from.getX();
                    x4 = to.getX() + to.getWidth();
                    x2 = x3 = x4 + (x1 - x4) / 2.0;
                    break;
                }
                default: {
                    x1 = from.getX() + from.getWidth();
                    x4 = to.getX();
                    x2 = x3 = x1 + (x4 - x1) / 2.0;
                }
            }
            y1 = y2 = fc.getY();
            y3 = y4 = tc.getY();
        }
        Point2D.Double pt = new Point2D.Double(x1, y1);
        Line2D.Double line = new Line2D.Double(pt, fc);
        Point2D np = GeomUtils.findIntersection((Line2D)line, fromShape);
        if (np != null) {
            x1 = (int)np.getX();
            y1 = (int)np.getY();
        }
        ((Point2D)pt).setLocation(x4, y4);
        line = new Line2D.Double(pt, tc);
        np = GeomUtils.findIntersection((Line2D)line, toShape);
        if (np != null) {
            x4 = (int)np.getX();
            y4 = (int)np.getY();
        }
        this.draw(g, x1, y1, x2, y2, x3, y3, x4, y4, fromJoin, toJoin);
    }

    public final void draw(Graphics g, double x1, double y1, double x2, double y2, double x3, double y3, double x4, double y4, JoinEnd fromJoin, JoinEnd toJoin) {
        this.draw((Graphics2D)g, x1, y1, x2, y2, x3, y3, x4, y4, fromJoin, toJoin);
    }

    public final void draw(Graphics2D g, double x1, double y1, double x2, double y2, double x3, double y3, double x4, double y4, JoinEnd fromJoin, JoinEnd toJoin) {
        this.draw(g, x1, y1, x2, y2, x3, y3, x4, y4, fromJoin, toJoin, null, null);
    }

    public final void draw(Graphics2D g, double x1, double y1, double x2, double y2, double x3, double y3, double x4, double y4, JoinEnd fromJoin, JoinEnd toJoin, Color color) {
        this.draw(g, x1, y1, x2, y2, x3, y3, x4, y4, fromJoin, toJoin, color, color);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void draw(Graphics2D g, double x1, double y1, double x2, double y2, double x3, double y3, double x4, double y4, JoinEnd fromJoin, JoinEnd toJoin, Color borderColor, Color fillColor) {
        Graphics2D g2 = (Graphics2D)g.create();
        try {
            GeneralPath p = new GeneralPath();
            if (this.fillable) {
                this.appendPath(p, (float)x1, (float)y1, (float)x2, (float)y2, (float)x3, (float)y3, (float)x4, (float)y4, fromJoin, toJoin, true);
                if (fillColor != null) {
                    g2.setColor(fillColor);
                } else if (borderColor != null) {
                    g2.setColor(borderColor);
                }
                g2.fill(p);
                p.reset();
            }
            this.appendPath(p, (float)x1, (float)y1, (float)x2, (float)y2, (float)x3, (float)y3, (float)x4, (float)y4, fromJoin, toJoin, false);
            if (borderColor != null) {
                g2.setColor(borderColor);
            }
            switch (this.mode) {
                case 0: {
                    break;
                }
                case 1: {
                    GeomUtils.setDashStroke(g2, 8.0f, 4.0f);
                    break;
                }
                case 2: {
                    GeomUtils.setDashStroke(g2, 4.0f, 4.0f);
                }
            }
            g2.draw(p);
        }
        finally {
            g2.dispose();
        }
    }

    public final GeneralPath appendPath(GeneralPath p, float x1, float y1, float x2, float y2, float x3, float y3, float x4, float y4, JoinEnd fromJoin, JoinEnd toJoin, boolean forFill) {
        if (p == null) {
            p = new GeneralPath();
        }
        Point2D.Float pt = fromJoin.getJoinPoint(x1, y1, x2, y2);
        float x1a = (float)((Point2D)pt).getX();
        float y1a = (float)((Point2D)pt).getY();
        pt = toJoin.getJoinPoint(x4, y4, x3, y3);
        float x4a = (float)((Point2D)pt).getX();
        float y4a = (float)((Point2D)pt).getY();
        p = fromJoin.appendPath(p, x1, y1, x1a, y1a, false, forFill);
        switch (this) {
            default: {
                p.lineTo(x2, y2);
                p.lineTo(x3, y3);
                p.lineTo(x4a, y4a);
                break;
            }
            case DIRECT: 
            case DIRECT_DASHED: 
            case DIRECT_DOTTED: {
                p.lineTo(x4a, y4a);
                break;
            }
            case CUBIC: 
            case CUBIC_DASHED: 
            case CUBIC_DOTTED: {
                p.curveTo(x2, y2, x3, y3, x4a, y4a);
                break;
            }
            case QUAD: 
            case QUAD_DASHED: 
            case QUAD_DOTTED: {
                p.quadTo(x2, y2, x2 + (x3 - x2) / 2.0f, y2 + (y3 - y2) / 2.0f);
                p.quadTo(x3, y3, x4a, y4a);
            }
        }
        p = toJoin.appendPath(p, x4, y4, x4a, y4a, true, forFill);
        if (forFill) {
            switch (this) {
                default: {
                    p.lineTo(x3, y3);
                    p.lineTo(x2, y2);
                    p.lineTo(x1a, y1a);
                    break;
                }
                case DIRECT: 
                case DIRECT_DASHED: 
                case DIRECT_DOTTED: {
                    p.lineTo(x1a, y1a);
                    break;
                }
                case CUBIC: 
                case CUBIC_DASHED: 
                case CUBIC_DOTTED: {
                    p.curveTo(x3, y3, x2, y2, x1a, y1a);
                    break;
                }
                case QUAD: 
                case QUAD_DASHED: 
                case QUAD_DOTTED: {
                    p.quadTo(x3, y3, x2 + (x3 - x2) / 2.0f, y2 + (y3 - y2) / 2.0f);
                    p.quadTo(x2, y2, x1a, y1a);
                }
            }
        }
        return p;
    }

    @Override
    public String getDescription() {
        return StringUtils.capitaliseEnum(this.toString());
    }

    @Override
    public void render(Graphics2D g, int w, int h) {
        double x1 = ((double)w - 8.0) / 3.0;
        double x2 = x1 + x1;
        double x3 = x2 + x1;
        double y1 = (double)h / 3.0;
        double y2 = y1 + y1;
        this.draw(g, x1, y1, x2, y1, x2, y2, x3, y2, JoinEnd.NONE, JoinEnd.NONE);
    }
}

