/*
 * Decompiled with CFR 0.152.
 */
package uk.org.retep.util.collections.map;

import java.util.EnumMap;
import java.util.Map;
import uk.org.retep.util.string.StringUtils;

public class StringEnumMap<T extends Enum<T>, V>
extends EnumMap<T, V> {
    private static final long serialVersionUID = 526217537704874685L;
    private final T validKeys;
    private final boolean convertStringKeys;

    public StringEnumMap(T validKeys) {
        this(validKeys, false);
    }

    public StringEnumMap(T validKeys, Map<T, V> map) {
        this(validKeys, map, false);
    }

    public StringEnumMap(T validKeys, boolean convertStringKeys) {
        super(validKeys.getClass());
        this.validKeys = validKeys;
        this.convertStringKeys = convertStringKeys;
    }

    public StringEnumMap(T validKeys, Map<T, V> map, boolean convertStringKeys) {
        super(map);
        this.validKeys = validKeys;
        this.convertStringKeys = convertStringKeys;
    }

    public final boolean isConvertStringKeys() {
        return this.convertStringKeys;
    }

    protected final T getKey(String key) {
        if (this.convertStringKeys) {
            return (T)Enum.valueOf(this.validKeys.getClass(), StringUtils.getEnumValue(key));
        }
        return (T)Enum.valueOf(this.validKeys.getClass(), key);
    }

    @Override
    public V get(Object key) {
        if (key instanceof String) {
            return super.get(this.getKey(key.toString()));
        }
        return super.get(key);
    }

    @Override
    public V put(String key, V value) {
        return this.put(this.getKey(key), value);
    }

    @Override
    public boolean containsKey(Object key) {
        if (key instanceof String) {
            return super.containsKey(this.getKey(key.toString()));
        }
        return super.containsKey(key);
    }

    @Override
    public V remove(Object key) {
        if (key instanceof String) {
            return super.remove(this.getKey(key.toString()));
        }
        return super.remove(key);
    }
}

