/*
 * Decompiled with CFR 0.152.
 */
package uk.org.retep.util.collections.comparators;

import java.util.Comparator;

public class StringComparators {
    private static Natural natural;
    private static CaseInsensitive caseInsensitive;

    public static Comparator<String> getNaturalComparator() {
        if (natural == null) {
            natural = new Natural();
        }
        return natural;
    }

    public static Comparator<String> getCaseInsensitiveComparator() {
        if (caseInsensitive == null) {
            caseInsensitive = new CaseInsensitive();
        }
        return caseInsensitive;
    }

    private static class CaseInsensitive
    implements Comparator<String> {
        private CaseInsensitive() {
        }

        @Override
        public int compare(String a, String b) {
            return a.compareToIgnoreCase(b);
        }
    }

    private static class Natural
    implements Comparator<String> {
        private Natural() {
        }

        @Override
        public int compare(String a, String b) {
            return a.compareTo(b);
        }
    }
}

