/*
 * Decompiled with CFR 0.152.
 */
package uk.org.retep.util.collections;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import java.util.WeakHashMap;

public class WeakHashSet<E>
extends AbstractSet<E>
implements Set<E>,
Cloneable,
Serializable {
    static final long serialVersionUID = -3216765406713024744L;
    private static final int DEFAULT_INITIAL_CAPACITY = 16;
    private static final float DEFAULT_LOAD_FACTOR = 0.75f;
    private transient WeakHashMap<E, Object> map;
    private static final Object PRESENT = new Object();

    public WeakHashSet() {
        this(16, 0.75f);
    }

    public WeakHashSet(Collection<? extends E> c) {
        this(Math.max((int)((float)c.size() / 0.75f) + 1, 16), 0.75f);
        this.addAll(c);
    }

    public WeakHashSet(int initialCapacity) {
        this(initialCapacity, 0.75f);
    }

    public WeakHashSet(int initialCapacity, float loadFactor) {
        this.map = new WeakHashMap(initialCapacity, loadFactor);
    }

    @Override
    public Iterator<E> iterator() {
        return this.map.keySet().iterator();
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.map.containsKey(o);
    }

    @Override
    public boolean add(E e) {
        return this.map.put(e, PRESENT) == null;
    }

    @Override
    public boolean remove(Object o) {
        return this.map.remove(o) == PRESENT;
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    public Object clone() {
        try {
            WeakHashSet newSet = (WeakHashSet)super.clone();
            newSet.map = new WeakHashMap();
            newSet.map.putAll(this.map);
            return newSet;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        s.writeInt(this.map.size());
        for (E e : this.map.keySet()) {
            s.writeObject(e);
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.map = new WeakHashMap();
        int size = s.readInt();
        for (int i = 0; i < size; ++i) {
            Object e = s.readObject();
            this.map.put(e, PRESENT);
        }
    }
}

