/*
 * Decompiled with CFR 0.152.
 */
package uk.org.retep.util.collections;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import uk.org.retep.util.collections.TimedMap;

public class TimedHashMap<K, V>
extends HashMap<K, V>
implements TimedMap<K, V> {
    static final long serialVersionUID = 6953795673173999149L;
    private Map<K, TimedHashMapEntry<V>> map = new HashMap<K, TimedHashMapEntry<V>>();
    private long lifetime = 600000L;

    public TimedHashMap() {
    }

    public TimedHashMap(long lifetime) {
        this();
        this.setLifetime(lifetime);
    }

    @Override
    public void setLifetime(long millis) {
        this.lifetime = millis;
    }

    @Override
    public long getLifetime() {
        return this.lifetime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V get(Object key) {
        TimedHashMap timedHashMap = this;
        synchronized (timedHashMap) {
            V ret = null;
            TimedHashMapEntry<V> ce = this.map.get(key);
            if (ce != null) {
                long deathTime = ce.getCreated() + this.lifetime;
                if (deathTime > System.currentTimeMillis()) {
                    ret = ce.getObject();
                } else {
                    this.remove(key);
                }
            }
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V put(K key, V value) {
        TimedHashMap timedHashMap = this;
        synchronized (timedHashMap) {
            V ret = null;
            TimedHashMapEntry<V> ce = this.map.get(key);
            if (ce == null) {
                ce = this.map.put(key, new TimedHashMapEntry<V>(value));
                if (ce != null) {
                    ret = ce.getObject();
                }
            } else {
                ret = ce.getObject();
                ce.setObject(value);
            }
            return ret;
        }
    }

    @Override
    public Collection<V> values() {
        return new CacheCollection<V>(this.map.values());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearTombstones() {
        TimedHashMap timedHashMap = this;
        synchronized (timedHashMap) {
            Iterator it = this.keySet().iterator();
            while (it.hasNext()) {
                long deathTime;
                Object key = it.next();
                TimedHashMapEntry ce = (TimedHashMapEntry)super.get(key);
                if (ce == null || (deathTime = ce.getCreated() + this.lifetime) > System.currentTimeMillis()) continue;
                it.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearPrefix(String prefix) {
        TimedHashMap timedHashMap = this;
        synchronized (timedHashMap) {
            Iterator it = this.keySet().iterator();
            while (it.hasNext()) {
                Object key = it.next();
                TimedHashMapEntry ce = (TimedHashMapEntry)super.get(key);
                if (ce == null || !(key instanceof String) || !((String)key).startsWith(prefix)) continue;
                it.remove();
            }
        }
    }

    private class TimedHashMapEntry<V> {
        private V object;
        private long created;

        public TimedHashMapEntry() {
            this(null);
        }

        public TimedHashMapEntry(V aObject) {
            this.setObject(aObject);
        }

        public V getObject() {
            return this.object;
        }

        public void setObject(V object) {
            this.object = object;
            this.setCreated(System.currentTimeMillis());
        }

        public long getCreated() {
            return this.created;
        }

        public void setCreated(long aCreated) {
            this.created = aCreated;
        }
    }

    private class CacheCollection<V>
    implements Collection<V> {
        private Collection<TimedHashMapEntry<V>> col;

        public CacheCollection(Collection<TimedHashMapEntry<V>> aCollection) {
            this.col = aCollection;
        }

        @Override
        public boolean add(V o) {
            return this.col.add(new TimedHashMapEntry<V>(o));
        }

        @Override
        public boolean addAll(Collection<? extends V> c) {
            Iterator<V> it = c.iterator();
            boolean changed = false;
            while (it.hasNext()) {
                V obj = it.next();
                if (obj instanceof TimedHashMapEntry) {
                    changed |= this.col.add((TimedHashMapEntry)obj);
                    continue;
                }
                changed |= this.col.add(new TimedHashMapEntry<V>(obj));
            }
            return changed;
        }

        @Override
        public void clear() {
            this.col.clear();
        }

        @Override
        public boolean contains(Object o) {
            boolean notFound = true;
            Iterator<TimedHashMapEntry<V>> it = this.col.iterator();
            while (notFound && it.hasNext()) {
                TimedHashMapEntry<V> ce = it.next();
                notFound = !ce.getObject().equals(o);
            }
            return !notFound;
        }

        @Override
        public boolean containsAll(Collection c) {
            boolean found = true;
            Iterator it = c.iterator();
            while (found && it.hasNext()) {
                found = this.contains(it.next());
            }
            return found;
        }

        @Override
        public boolean isEmpty() {
            return this.col.isEmpty();
        }

        @Override
        public Iterator<V> iterator() {
            return new CacheIterator<V>(this.col);
        }

        @Override
        public boolean remove(Object o) {
            boolean run = true;
            Iterator<TimedHashMapEntry<V>> it = this.col.iterator();
            while (run && it.hasNext()) {
                if (!o.equals(it.next())) continue;
                it.remove();
                run = false;
            }
            return !run;
        }

        @Override
        public boolean removeAll(Collection c) {
            boolean changed = false;
            for (Object o : c) {
                boolean removed = false;
                do {
                    removed = this.remove(o);
                    changed |= removed;
                } while (removed);
            }
            return changed;
        }

        @Override
        public boolean retainAll(Collection c) {
            return false;
        }

        @Override
        public int size() {
            return this.col.size();
        }

        @Override
        public Object[] toArray() {
            Object[] ary = new Object[this.size()];
            Iterator<TimedHashMapEntry<V>> it = this.col.iterator();
            int i = 0;
            while (it.hasNext()) {
                ary[i] = it.next();
                ++i;
            }
            return ary;
        }

        @Override
        public <T> T[] toArray(T[] a) {
            return a;
        }
    }

    private class CacheIterator<V>
    implements Iterator<V> {
        private Iterator<V> iterator;

        public CacheIterator(Collection<TimedHashMapEntry<V>> col) {
            ArrayList<V> l = new ArrayList<V>();
            for (TimedHashMapEntry<V> e : col) {
                l.add(e.getObject());
            }
            this.iterator = l.iterator();
        }

        public CacheIterator(Iterator<V> it) {
            this.iterator = it;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public V next() {
            V obj = this.iterator.next();
            if (obj instanceof TimedHashMapEntry) {
                obj = ((TimedHashMapEntry)obj).getObject();
            }
            return obj;
        }

        @Override
        public void remove() {
            this.iterator.remove();
        }
    }
}

