/*
 * Decompiled with CFR 0.152.
 */
package uk.org.retep.util.classloader;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import uk.org.retep.util.classloader.CachingInputStreamClassLoader;
import uk.org.retep.util.io.FileUtils;

public class JarClassLoader
extends CachingInputStreamClassLoader {
    private JarFile jarFile;

    public JarClassLoader(String jar) throws IOException {
        this(new File(jar));
    }

    public JarClassLoader(File jar) throws IOException {
        this.jarFile = new JarFile(jar);
    }

    public JarClassLoader(String jar, ClassLoader parent) throws IOException {
        super(parent);
        this.jarFile = new JarFile(jar);
    }

    public JarClassLoader(File jar, ClassLoader parent) throws IOException {
        super(parent);
        this.jarFile = new JarFile(jar);
    }

    public void close() throws IOException {
        this.jarFile.close();
    }

    private String fixName(String classname) {
        return classname.replace('.', '/') + ".class";
    }

    @Override
    protected byte[] readBytes(String className) throws IOException {
        ZipEntry entry = this.jarFile.getEntry(this.fixName(className));
        return FileUtils.readBytes(this.jarFile.getInputStream(entry));
    }

    @Override
    protected URL findResource(String name) {
        return null;
    }
}

