/*
 * Decompiled with CFR 0.152.
 */
package uk.org.retep.util.thread;

import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import uk.org.retep.util.collections.ConcurrencySupport;
import uk.org.retep.util.thread.GlobalThreadPool;

public class ShutdownManager
extends ConcurrencySupport
implements Runnable {
    private static ShutdownManager instance;
    private final Thread thread;
    private final Deque<Runnable> tasks;
    private final Map<ExecutorService, Runnable> execTasks = new HashMap<ExecutorService, Runnable>();

    private static synchronized ShutdownManager getInstance() {
        if (instance == null) {
            instance = new ShutdownManager();
        }
        return instance;
    }

    private ShutdownManager() {
        this.tasks = new LinkedList<Runnable>();
        this.thread = GlobalThreadPool.createThread("Runtime", this);
    }

    public static void addShutdownHook(Runnable task) {
        ShutdownManager.getInstance().add(task);
    }

    public static void removeShutdownHook(Runnable task) {
        ShutdownManager.getInstance().remove(task);
    }

    public static void addExecutorServiceShutdown(ExecutorService service) {
        ShutdownManager.getInstance().add(service);
    }

    public static void removeExecutorServiceShutdown(ExecutorService service) {
        ShutdownManager.getInstance().remove(service);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void add(Runnable task) {
        this.writeLock().lock();
        try {
            boolean wasEmpty = this.tasks.isEmpty();
            this.tasks.push(task);
            this.getLog().info("Added Shutdown task %s", task);
            if (wasEmpty) {
                Runtime.getRuntime().addShutdownHook(this.thread);
                this.getLog().info("Added ShutdownHook to Runtime");
            }
        }
        finally {
            this.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void remove(Runnable task) {
        this.writeLock().lock();
        try {
            if (this.tasks.remove(task)) {
                this.getLog().info("Removed Shutdown task %s", task);
                if (this.tasks.isEmpty()) {
                    Runtime.getRuntime().removeShutdownHook(this.thread);
                    this.getLog().info("Removed ShutdownHook from Runtime");
                }
            }
        }
        finally {
            this.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void add(final ExecutorService service) {
        this.writeLock().lock();
        try {
            Runnable task = this.execTasks.get(service);
            if (task != null) {
                task = new Runnable(){

                    @Override
                    public void run() {
                        service.shutdownNow();
                    }
                };
                this.add(task);
                this.execTasks.put(service, task);
            }
        }
        finally {
            this.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void remove(ExecutorService service) {
        this.writeLock().lock();
        try {
            Runnable task = this.execTasks.remove(service);
            if (task != null) {
                this.remove(task);
            }
        }
        finally {
            this.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.readLock().lock();
        try {
            this.getLog().info("Running %d Shutdown tasks", this.tasks.size());
            while (!this.tasks.isEmpty()) {
                Runnable task = this.tasks.pop();
                try {
                    task.run();
                }
                catch (Throwable t) {
                    this.getLog().error("Shutdown task %s failed due to %s", t, t.getClass(), task);
                }
            }
        }
        finally {
            this.readLock().unlock();
        }
    }
}

