/*
 * Decompiled with CFR 0.152.
 */
package uk.org.retep.util.graphics;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;

public enum TextAlignment {
    LEFT,
    RIGHT,
    CENTER,
    CENTRE;


    public static TextAlignment valueOfWithDefault(String name) {
        return TextAlignment.valueOfWithDefault(name, LEFT);
    }

    public static TextAlignment valueOfWithDefault(String name, TextAlignment defaultAlignment) {
        try {
            return name == null ? defaultAlignment : TextAlignment.valueOf(name.toUpperCase());
        }
        catch (Exception e) {
            return defaultAlignment;
        }
    }

    public double drawEmbossedString(Graphics g, String src, Rectangle rect) {
        return this.drawEmbossedString(g, g.getFontMetrics(), src, rect.getX(), rect.getY(), rect.getWidth());
    }

    public double drawEmbossedString(Graphics g, FontMetrics fm, String src, double left, double y, double width) {
        Color c = g.getColor();
        g.setColor(c.brighter());
        double ret = this.drawString(g, fm, src, left + 1.0, y + 1.0, width);
        g.setColor(c.darker());
        this.drawString(g, fm, src, left, y, width);
        g.setColor(c);
        return ret;
    }

    public double drawString(Graphics g, String src, Rectangle rect) {
        return this.drawString(g, g.getFontMetrics(), src, rect.getX(), rect.getY(), rect.getWidth());
    }

    public double drawString(Graphics g, FontMetrics fm, String src, double left, double y, double width) {
        double w = fm.stringWidth(src);
        if (w > width) {
            String t;
            String s = t = src;
            double y1 = y;
            while (s.length() > 0) {
                while (w > width && t.lastIndexOf(32) > -1) {
                    t = t.substring(0, t.lastIndexOf(32));
                    w = fm.stringWidth(t);
                }
                if (w > width) {
                    while (w > width) {
                        t = t.substring(0, t.length() - 1);
                    }
                    s = s.substring(t.length());
                } else {
                    s = s.substring(t.length() + 1);
                }
                y1 = this.drawStringImpl(g, fm, t, left, y1, width);
            }
            return y1;
        }
        return this.drawStringImpl(g, fm, src, left, y, width);
    }

    private double drawStringImpl(Graphics g, FontMetrics fm, String s, double left, double y, double width) {
        switch (this) {
            case CENTER: 
            case CENTRE: {
                g.drawString(s, (int)(left + (width - (double)fm.stringWidth(s)) / 2.0), (int)(y + (double)fm.getMaxAscent()));
                break;
            }
            case LEFT: {
                g.drawString(s, (int)left, (int)(y + (double)fm.getMaxAscent()));
                break;
            }
            case RIGHT: {
                g.drawString(s, (int)(left + width - (double)fm.stringWidth(s)), (int)(y + (double)fm.getMaxAscent()));
            }
        }
        return y + (double)fm.getHeight();
    }
}

