/*
 * Decompiled with CFR 0.152.
 */
package uk.org.retep.util.state;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public final class ActivityList<T> {
    private List<T> list = new LinkedList<T>();
    private List<Listener<T>> listeners;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T getActive() {
        T ret = null;
        List<T> list = this.list;
        synchronized (list) {
            if (this.list.size() >= 0) {
                ret = this.get(0);
            }
            return ret;
        }
    }

    public T get(int i) {
        return this.list.get(i);
    }

    public int size() {
        return this.list.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void activate(T obj) {
        List<T> list = this.list;
        synchronized (list) {
            if (this.list.contains(obj)) {
                this.list.remove(obj);
                this.list.add(0, obj);
                this.fireActivated(obj);
            } else {
                this.list.add(0, obj);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deactivate(T obj) {
        List<T> list = this.list;
        synchronized (list) {
            if (this.list.contains(obj)) {
                this.list.remove(obj);
                this.list.add(obj);
            } else {
                this.list.add(obj);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(T obj) {
        List<T> list = this.list;
        synchronized (list) {
            int idx = this.list.indexOf(obj);
            this.list.remove(obj);
            if (idx == 0) {
                this.fireActivated(this.list.size() > 0 ? (T)this.list.get(0) : null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replace(T oldObj, T newObj) {
        if (oldObj != null || newObj != null) {
            List<T> list = this.list;
            synchronized (list) {
                int i;
                if (newObj == null) {
                    this.remove(oldObj);
                    return;
                }
                int n = i = oldObj != null ? this.list.indexOf(oldObj) : -1;
                if (i == -1) {
                    this.list.add(newObj);
                } else {
                    this.list.set(i, newObj);
                    if (i == 0) {
                        this.fireActivated(newObj);
                    }
                }
            }
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ActivityList [size=").append(this.size());
        for (T elem : this.list) {
            sb.append(',');
            sb.append(elem);
        }
        return sb.append("]").toString();
    }

    public Iterator<T> iterator() {
        return this.list.iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(Listener<T> l) {
        ActivityList activityList = this;
        synchronized (activityList) {
            if (this.listeners == null) {
                this.listeners = new LinkedList<Listener<T>>();
            }
            if (!this.listeners.contains(l)) {
                this.listeners.add(l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(Listener<T> l) {
        ActivityList activityList = this;
        synchronized (activityList) {
            if (this.listeners != null && this.listeners.contains(l)) {
                this.listeners.remove(l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireActivated(T o) {
        ActivityList activityList = this;
        synchronized (activityList) {
            if (this.listeners == null) {
                return;
            }
            for (Listener<T> l : this.listeners) {
                l.activityListActivated(this, o);
            }
        }
    }

    public static interface Listener<T> {
        public void activityListActivated(ActivityList<T> var1, T var2);
    }
}

