/*
 * Decompiled with CFR 0.152.
 */
package uk.org.retep.util.node;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import uk.org.retep.util.node.Node;

public abstract class AbstractNode
implements Node {
    private Node parent;
    List<Node> children;

    @Override
    public final <T extends Node> T getParent() {
        return (T)this.parent;
    }

    public void setParent(Node parent) {
        this.parent = parent;
    }

    @Override
    public final int getDepth() {
        return this.parent == null ? 0 : this.parent.getDepth() + 1;
    }

    public final boolean isRoot() {
        return this.parent == null;
    }

    @Override
    public final boolean isLeaf() {
        return this.children == null || this.children.isEmpty();
    }

    @Override
    public boolean canHaveChildren() {
        return true;
    }

    @Override
    public final <T extends Node> Collection<T> getChildren() {
        ArrayList<Node> ret = new ArrayList<Node>();
        if (this.children != null) {
            ret.addAll(this.children);
        }
        return ret;
    }

    @Override
    public final int childCount() {
        return this.children == null ? 0 : this.children.size();
    }

    @Override
    public final <T extends Node> T getChildAt(int index) {
        if (this.children == null || index < 0 || index >= this.children.size()) {
            return null;
        }
        return (T)this.children.get(index);
    }

    @Override
    public final <T extends Node> T add(T child) {
        if (!this.canHaveChildren()) {
            throw new UnsupportedOperationException("This Node cannot have children: " + this.getNodePath());
        }
        if (this.children == null) {
            this.children = new LinkedList<Node>();
        }
        if (child.getParent() != null) {
            child.getParent().remove(child);
        }
        this.children.add(child);
        if (child instanceof AbstractNode) {
            ((AbstractNode)AbstractNode.class.cast(child)).setParent(this);
        }
        return child;
    }

    @Override
    public <T extends Node> void addAll(Collection<T> child) {
        if (!this.canHaveChildren()) {
            throw new UnsupportedOperationException("This Node cannot have children: " + this.getNodePath());
        }
        for (Node c : child) {
            this.add(c);
        }
    }

    @Override
    public final <T extends Node> T insert(int index, T child) {
        if (!this.canHaveChildren()) {
            throw new UnsupportedOperationException("This Node cannot have children: " + this.getNodePath());
        }
        if (this.children == null) {
            this.children = new LinkedList<Node>();
        }
        if (child.getParent() != null) {
            child.getParent().remove(child);
        }
        this.children.add(index, child);
        if (child instanceof AbstractNode) {
            ((AbstractNode)AbstractNode.class.cast(child)).setParent(this);
        }
        return child;
    }

    @Override
    public final <T extends Node> T remove(T child) {
        if (this.children != null && this.children.remove(child)) {
            if (child instanceof AbstractNode) {
                ((AbstractNode)AbstractNode.class.cast(child)).setParent(null);
            }
            return child;
        }
        return null;
    }

    @Override
    public final void remove(int index) {
        Node child;
        if (this.children != null && (child = this.children.remove(index)) != null && child instanceof AbstractNode) {
            ((AbstractNode)AbstractNode.class.cast(child)).setParent(null);
        }
    }

    @Override
    public final void removeChildren() {
        if (this.children != null) {
            for (Node child : this.children) {
                if (!(child instanceof AbstractNode)) continue;
                ((AbstractNode)AbstractNode.class.cast(child)).setParent(null);
            }
            this.children = null;
        }
    }

    @Override
    public final <T extends Node> T getFirstChild() {
        if (this.children == null || this.children.size() == 0) {
            return null;
        }
        return (T)this.children.get(0);
    }

    @Override
    public final <T extends Node> T getLastChild() {
        if (this.children == null || this.children.size() == 0) {
            return null;
        }
        return (T)this.children.get(this.children.size() - 1);
    }

    @Override
    public final int getIndex() {
        if (this.parent == null || !(this.parent instanceof AbstractNode)) {
            return -1;
        }
        return ((AbstractNode)AbstractNode.class.cast((Object)this.parent)).children.indexOf(this);
    }

    @Override
    public final <T extends Node> T getPrevious() {
        int index = this.getIndex();
        if (index < 1) {
            return null;
        }
        return this.getParent().getChildAt(index - 1);
    }

    @Override
    public final <T extends Node> T getNext() {
        int index = this.getIndex();
        if (index < 0 || index >= this.getParent().childCount()) {
            return null;
        }
        return this.getParent().getChildAt(index + 1);
    }

    public final String toString() {
        StringBuilder sb = new StringBuilder();
        this.toString(0, sb);
        return sb.toString();
    }

    protected final void toString(int depth, StringBuilder sb) {
        if (depth > 0) {
            sb.append('\n');
            for (int i = 0; i < depth; ++i) {
                sb.append(' ');
            }
            sb.append('+');
        }
        sb.append(this.getClass().getName()).append("[leaf=").append(this.isLeaf());
        sb.append(",index=").append(this.getIndex());
        sb.append(",children=").append(this.childCount());
        this.toStringImpl(sb);
        sb.append(']');
        if (!this.isLeaf()) {
            for (Node child : this.children) {
                if (!(child instanceof AbstractNode)) continue;
                ((AbstractNode)AbstractNode.class.cast(child)).toString(depth + 2, sb);
            }
        }
    }

    protected void toStringImpl(StringBuilder sb) {
    }

    public final String getNodePath() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getName());
        for (Object n = this.getParent(); n != null; n = n.getParent()) {
            sb.insert(0, '/').insert(0, n.getClass().getName());
        }
        return sb.toString();
    }
}

