/*
 * Decompiled with CFR 0.152.
 */
package uk.org.retep.util.io;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class MP3
implements Serializable {
    static final long serialVersionUID = 3046921477852383265L;
    private Map<String, String> props = new HashMap<String, String>();
    public static final String YEAR = "TYER";
    public static final String ALBUM = "TALB";
    public static final String MED = "TMED";
    public static final String TRACK = "TRCK";
    public static final String LENGTH = "TLEN";
    public static final String URL_ARTIST = "WOAR";
    public static final String URL_BUYCD = "WCOM";
    public static final String URL_AUDIO = "WOAF";
    public static final String TITLE = "TIT2";
    public static final String LYRICS = "USLT";
    public static final String GENRE = "TCON";
    public static final String SITUATION = "MusicMatch_Situation";
    public static final String TEMPO = "MusicMatch_Tempo";
    public static final String NOTES = "notes";
    public static final String MOOD = "MusicMatch_Mood";
    public static final String BIO = "MusicMatch_Bio";

    public MP3() {
    }

    public MP3(File aFile) throws IOException {
        this.read(aFile);
    }

    public MP3(RandomAccessFile raf) throws IOException {
        this.read(raf);
    }

    public String get(String tag) {
        return this.props.get(tag);
    }

    public Iterator getTags() {
        return this.props.keySet().iterator();
    }

    public void read(File aFile) throws IOException {
        RandomAccessFile raf = new RandomAccessFile(aFile, "r");
        this.read(raf);
        raf.close();
    }

    public void read(RandomAccessFile raf) throws IOException {
        this.props.clear();
        byte[] b = new byte[2048];
        raf.seek(0L);
        raf.read(b, 0, 3);
        raf.read(b, 0, 7);
        while (this.ripTag(raf, b)) {
        }
    }

    private boolean ripTag(RandomAccessFile raf, byte[] b) throws IOException {
        int p;
        if (raf.read(b, 0, 4) < 4) {
            return false;
        }
        if (b[0] == 0 && b[1] == 0 && b[2] == 0 && b[3] == 0) {
            return false;
        }
        String key = new String(b, 0, 4);
        int l = raf.readInt();
        raf.read(b, 0, 2);
        byte[] r = new byte[l];
        raf.read(r);
        if (key.equals("COMM") && r[0] == 0 && r[1] == 0 && r[2] == 0 && r[3] == 0) {
            for (p = 4; p < r.length && r[p] != 0; ++p) {
            }
            int q = p;
            while (p < r.length && r[p] == 0) {
                ++p;
            }
            if (p > 3 && p < r.length) {
                key = new String(r, 4, q - 4);
                byte[] s = new byte[l - p];
                System.arraycopy(r, p, s, 0, s.length);
                r = s;
            }
        }
        for (p = 0; p < r.length && r[p] == 0; ++p) {
        }
        this.props.put(key, new String(r, p, r.length - p));
        return true;
    }

    public static void main(String[] args) throws Exception {
        for (int i = 0; i < args.length; ++i) {
            MP3 mp3 = new MP3(new File(args[i]));
            System.out.println("Details about file: " + args[i] + "\n===================");
            Iterator it = mp3.getTags();
            while (it.hasNext()) {
                String tag = (String)it.next();
                System.out.println(tag + "\t\"" + mp3.get(tag) + "\"");
            }
            System.out.println();
        }
    }
}

