/*
 * Decompiled with CFR 0.152.
 */
package uk.org.retep.util.collections.set;

import java.util.Iterator;
import java.util.NoSuchElementException;
import uk.org.retep.util.collections.set.OrderedSet;

public class LinkedOrderedSet<K, V>
implements OrderedSet<K, V> {
    protected OSEntry<K, V> head;
    protected OSEntry<K, V> tail;

    @Override
    public Iterator<V> iterator() {
        return new ForwardIterator<V>(this.head);
    }

    @Override
    public Iterator<V> reversedIterator() {
        return new ReversedIterator<V>(this.tail);
    }

    @Override
    public final boolean isEmpty() {
        return this.head == null;
    }

    @Override
    public OrderedSet.Entry<K, V> findHead() {
        return this.head;
    }

    @Override
    public OrderedSet.Entry<K, V> findTail() {
        return this.tail;
    }

    @Override
    public V get(K key) {
        return this.getImpl(key);
    }

    @Override
    public V remove(K key) {
        return this.removeImpl(key);
    }

    @Override
    public OrderedSet.Entry<K, V> findEntry(K key) {
        return this.findEntryImpl(key);
    }

    @Override
    public int indexOf(K key) {
        return this.indexOfImpl(key);
    }

    @Override
    public final OrderedSet.Entry<K, V> createEntry(K before, K after, K key, V value) {
        return new OSEntry<K, V>(before, after, key, value);
    }

    @Override
    public void append(K key, V value) {
        this.appendImpl(key, value);
    }

    @Override
    public final void add(K before, K after, K key, V value) {
        if (before != null) {
            this.addBefore(before, key, value);
        } else {
            this.addAfter(after, key, value);
        }
    }

    @Override
    public void addBefore(K before, K key, V value) {
        this.addBeforeImpl(before, new OSEntry<Object, V>(before, null, key, value));
    }

    @Override
    public void addAfter(K after, K key, V value) {
        this.addAfterImpl(after, new OSEntry<Object, V>(null, after, key, value));
    }

    @Override
    public void insertEntry(OrderedSet.Entry<K, V> prev, OrderedSet.Entry<K, V> next, OrderedSet.Entry<K, V> entry) {
        if (entry != null && entry instanceof OSEntry && (prev == null || prev instanceof OSEntry) && (next == null || next instanceof OSEntry)) {
            this.insertEntryImpl((OSEntry)prev, (OSEntry)next, (OSEntry)entry);
        }
    }

    @Override
    public void removeEntry(OrderedSet.Entry<K, V> entry) {
        if (entry != null && entry instanceof OSEntry) {
            this.removeEntryImpl((OSEntry)entry);
        }
    }

    @Override
    public void clear() {
        this.clearImpl();
    }

    @Override
    public void reorder() {
        this.reorderImpl();
    }

    protected final V getImpl(K key) {
        OSEntry<K, V> entry = this.findEntryImpl(key);
        return entry == null ? null : (V)entry.getValue();
    }

    protected final V removeImpl(K key) {
        OSEntry<K, V> entry = this.findEntryImpl(key);
        this.removeEntryImpl(entry);
        return entry == null ? null : (V)entry.getValue();
    }

    protected OSEntry<K, V> findEntryImpl(K key) {
        if (key == null) {
            return null;
        }
        for (OrderedSet.Entry<K, V> e = this.head; e != null; e = e.getNext()) {
            if (!key.equals(e.getKey())) continue;
            return e;
        }
        return null;
    }

    protected int indexOfImpl(K key) {
        if (key == null) {
            return -1;
        }
        int idx = 0;
        OrderedSet.Entry<K, V> e = this.head;
        while (e != null) {
            if (key.equals(e.getKey())) {
                return idx;
            }
            e = e.getNext();
            ++idx;
        }
        return -1;
    }

    protected final void appendImpl(K key, V value) {
        this.insertEntryImpl(this.tail, null, new OSEntry<Object, V>(null, null, key, value));
    }

    protected final void addBeforeImpl(K after, OSEntry<K, V> entry) {
        OrderedSet.Entry prev = null;
        OSEntry<K, V> next = this.findEntryImpl(after);
        if (next == null) {
            next = this.head;
        }
        if (next != null) {
            prev = next.getPrev();
        }
        this.insertEntryImpl((OSEntry<K, V>)prev, next, entry);
    }

    protected final void addAfterImpl(K after, OSEntry<K, V> entry) {
        OSEntry<K, V> prev = this.findEntryImpl(after);
        OrderedSet.Entry next = null;
        if (prev == null) {
            prev = this.tail;
        }
        if (prev != null) {
            next = prev.getNext();
        }
        this.insertEntryImpl(prev, (OSEntry<K, V>)next, entry);
    }

    protected final void insertEntryImpl(OSEntry<K, V> prev, OSEntry<K, V> next, OSEntry<K, V> entry) {
        if (entry == null || entry.isInList()) {
            return;
        }
        if (prev == null) {
            if (this.head != null) {
                this.head.setPrev(entry);
            }
            next = this.head;
            this.head = entry;
        } else {
            prev.setNext(entry);
        }
        if (next == null) {
            if (this.tail != null) {
                this.tail.setNext(entry);
            }
            prev = this.tail;
            this.tail = entry;
        } else {
            next.setPrev(entry);
        }
        entry.setPrev(prev);
        entry.setNext(next);
        this.entryInserted(entry);
    }

    protected void entryInserted(OSEntry<K, V> entry) {
        entry.setSet(this);
    }

    protected final void removeEntryImpl(OSEntry<K, V> entry) {
        if (entry == null || !entry.isInList() || !this.equals(entry.getSet())) {
            return;
        }
        OrderedSet.Entry prev = entry.getPrev();
        OrderedSet.Entry next = entry.getNext();
        if (prev == null && next == null) {
            return;
        }
        if (prev == null) {
            this.head = this.head.getNext();
        } else {
            ((OSEntry)prev).setNext(next);
        }
        if (next == null) {
            this.tail = this.tail.getPrev();
        } else {
            ((OSEntry)next).setPrev(prev);
        }
        this.entryRemoved(entry);
    }

    protected void entryRemoved(OSEntry<K, V> entry) {
        entry.setSet(null);
    }

    protected final void clearImpl() {
        this.head = null;
        this.tail = null;
    }

    protected final void reorderImpl() {
        OrderedSet.Entry entry = this.head;
        this.clearImpl();
        while (entry != null) {
            OrderedSet.Entry next = entry.getNext();
            entry.setPrev(null);
            entry.setNext(null);
            entry.setSet(null);
            if (entry.getBefore() != null) {
                this.addBeforeImpl(entry.getBefore(), (OSEntry<K, V>)entry);
            } else {
                this.addAfterImpl(entry.getAfter(), (OSEntry<K, V>)entry);
            }
            entry = next;
        }
    }

    private class ReversedIterator<V>
    implements Iterator<V> {
        OSEntry<K, V> e;

        public ReversedIterator(OSEntry<K, V> tail) {
            this.e = tail;
        }

        @Override
        public boolean hasNext() {
            return this.e != null;
        }

        @Override
        public V next() {
            if (this.e == null) {
                throw new NoSuchElementException();
            }
            V val = this.e.getValue();
            this.e = this.e.getPrev();
            return val;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private class ForwardIterator<V>
    implements Iterator<V> {
        OSEntry<K, V> e;

        public ForwardIterator(OSEntry<K, V> head) {
            this.e = head;
        }

        @Override
        public boolean hasNext() {
            return this.e != null;
        }

        @Override
        public V next() {
            if (this.e == null) {
                throw new NoSuchElementException();
            }
            V val = this.e.getValue();
            this.e = this.e.getNext();
            return val;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    protected class OSEntry<K, V>
    implements OrderedSet.Entry<K, V> {
        private OSEntry<K, V> next;
        private OSEntry<K, V> prev;
        private OrderedSet set;
        private K key;
        private K before;
        private K after;
        private V value;

        public OSEntry(K before, K after, K key, V value) {
            this.before = before;
            this.after = after;
            this.key = key;
            this.value = value;
        }

        public boolean isInList() {
            return this.next != null && this.prev != null && this.set != null;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public OSEntry<K, V> getNext() {
            return this.next;
        }

        public void setNext(OSEntry<K, V> next) {
            this.next = next;
        }

        @Override
        public OSEntry<K, V> getPrev() {
            return this.prev;
        }

        public void setPrev(OSEntry<K, V> prev) {
            this.prev = prev;
        }

        @Override
        public OrderedSet getSet() {
            return this.set;
        }

        public void setSet(OrderedSet set) {
            this.set = set;
        }

        public K getBefore() {
            return this.before;
        }

        public K getAfter() {
            return this.after;
        }

        public int hashCode() {
            int h = 1;
            if (this.before != null) {
                h ^= this.before.hashCode();
            }
            if (this.after != null) {
                h ^= this.after.hashCode();
            }
            return h ^ this.key.hashCode();
        }

        public boolean equals(Object o) {
            if (o == null || !(o instanceof OSEntry)) {
                return false;
            }
            OSEntry k = (OSEntry)o;
            boolean f = true;
            f &= this.before == null ? k.before == null : this.before.equals(k.before);
            f &= this.after == null ? k.after == null : this.after.equals(k.after);
            return f &= this.key.equals(k.key);
        }
    }
}

