/*
 * Decompiled with CFR 0.152.
 */
package uk.num.validators;

import uk.num.validators.ValidationResult;

public class NumModuleNumberValidator {
    private NumModuleNumberValidator() {
    }

    public static ValidationResult validate(int moduleNumber) {
        ValidationResult result = new ValidationResult();
        if (moduleNumber < 0) {
            result.addMessage(ValidationResult.ErrorCode.NEGATIVE_MODULE_NUMBER, Integer.toString(moduleNumber));
        }
        return result;
    }

    public static ValidationResult validate(String moduleNumber) {
        ValidationResult result = new ValidationResult();
        int number = 0;
        try {
            number = Integer.parseInt(moduleNumber);
        }
        catch (Throwable e) {
            result.addMessage(ValidationResult.ErrorCode.INVALID_MODULE_NUMBER, moduleNumber);
        }
        if (number < 0) {
            result.addMessage(ValidationResult.ErrorCode.NEGATIVE_MODULE_NUMBER, moduleNumber);
        }
        return result;
    }
}

