/*
 * Decompiled with CFR 0.152.
 */
package uk.num.json_modl.converter;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.BooleanNode;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.NumericNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.util.List;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import uk.num.json_modl.converter.NamedNode;
import uk.num.json_modl.converter.UnicodeEscaper;
import uk.num.json_modl.converter.UtilFuncs;

public class JsonToModl {
    private static final Logger log = LogManager.getLogger(JsonToModl.class);
    private static final Function<JsonNode, Optional<String>> primitiveNodeToModl = node -> {
        if (node instanceof NullNode) {
            return Optional.of("000");
        }
        if (node instanceof TextNode) {
            if ("null".equals(node.textValue())) {
                return Optional.of("`null`");
            }
            return Optional.of(UtilFuncs.escapeAndQuote.apply(node.textValue()));
        }
        if (node instanceof BooleanNode) {
            boolean bool = node.booleanValue();
            String boolString = bool ? "01" : "00";
            return Optional.of(boolString);
        }
        if (node instanceof NumericNode) {
            return Optional.of("" + node.numberValue());
        }
        return Optional.empty();
    };
    private static final BiFunction<String, JsonNode, Optional<String>> primitiveToModl = (escapedKey, node) -> {
        Optional<String> nodeAsString = primitiveNodeToModl.apply((JsonNode)node);
        return nodeAsString.map(s -> escapedKey + "=" + s);
    };
    private static final Function<ObjectNode, String> objectToModlMapWithoutParentheses = node -> UtilFuncs.toNamedNodeList.apply((JsonNode)node).stream().map(namedNode -> JsonToModl.pairToModl(namedNode.name, namedNode.node)).collect(Collectors.joining(";"));
    private static final Function<JsonNode, String> toModl = node -> {
        if (node instanceof ArrayNode) {
            return JsonToModl.arrayToModlArray((ArrayNode)node);
        }
        if (node instanceof ObjectNode) {
            return "(" + objectToModlMapWithoutParentheses.apply((ObjectNode)node) + ")";
        }
        if (node.elements().hasNext()) {
            List<NamedNode> nodes = UtilFuncs.toNamedNodeList.apply((JsonNode)node);
            return nodes.stream().map(entry -> JsonToModl.pairToModl(entry.name, entry.node)).collect(Collectors.joining(";"));
        }
        return primitiveNodeToModl.apply((JsonNode)node).orElse("");
    };
    private static final Function<JsonNode, String> toTopLevelModl = node -> {
        if (node instanceof ObjectNode) {
            return objectToModlMapWithoutParentheses.apply((ObjectNode)node);
        }
        return toModl.apply((JsonNode)node);
    };

    private static String pairToModl(String key, JsonNode node) {
        String escapedKey = UnicodeEscaper.escape.apply(key);
        if (UtilFuncs.isNonStringPrimitive(escapedKey)) {
            escapedKey = "\"" + escapedKey + "\"";
        }
        if (node instanceof ArrayNode) {
            return escapedKey + JsonToModl.arrayToModlArray((ArrayNode)node);
        }
        if (node instanceof ObjectNode) {
            return escapedKey + "(" + objectToModlMapWithoutParentheses.apply((ObjectNode)node) + ")";
        }
        String constKey = escapedKey;
        return primitiveToModl.apply(escapedKey, node).orElseGet(() -> constKey + "(" + toModl.apply(node) + ")");
    }

    private static String arrayToModlArray(ArrayNode node) {
        return "[" + UtilFuncs.toList.apply(node).stream().map(toModl).collect(Collectors.joining(";")) + "]";
    }

    public String pairToModl(String json) {
        log.debug("Converting: {}", (Object)json);
        JsonNode node = UtilFuncs.mapJson.apply(json);
        String modlResult = node instanceof ArrayNode ? JsonToModl.pairToModl("", node) : toTopLevelModl.apply(node);
        log.debug("Result    : {}", (Object)modlResult);
        return modlResult;
    }
}

