/*
 * Decompiled with CFR 0.152.
 */
package uk.modl.interpreter;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import lombok.NonNull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class JsonToString {
    private static final Logger log = LogManager.getLogger(JsonToString.class);
    private static final ObjectMapper mapper = new ObjectMapper();

    public static String convertPretty(@NonNull JsonNode jsonNode) {
        if (jsonNode == null) {
            throw new NullPointerException("jsonNode is marked non-null but is null");
        }
        return JsonToString.convert(mapper.writerWithDefaultPrettyPrinter(), jsonNode);
    }

    public static String convert(@NonNull JsonNode jsonNode) {
        if (jsonNode == null) {
            throw new NullPointerException("jsonNode is marked non-null but is null");
        }
        return JsonToString.convert(mapper.writer(), jsonNode);
    }

    private static String convert(@NonNull ObjectWriter m, @NonNull JsonNode node) {
        if (m == null) {
            throw new NullPointerException("m is marked non-null but is null");
        }
        if (node == null) {
            throw new NullPointerException("node is marked non-null but is null");
        }
        try {
            return m.writeValueAsString((Object)node);
        }
        catch (JsonProcessingException e) {
            log.error((Object)e);
            return "JSON processing error";
        }
    }

    private JsonToString() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

