/*
 * Decompiled with CFR 0.152.
 */
package uk.modl.utils;

class UnicodeEscapeReplacer {
    private static final String BACKSLASH_U = "\\u";
    private static final String TILDE_U = "~u";
    private static final char TILDE = '~';
    private static final char BACKSLASH = '\\';
    private static final int HEX = 16;

    UnicodeEscapeReplacer() {
    }

    static String convertUnicodeSequences(String str) {
        int start = 0;
        String result = str;
        while (result != null) {
            int backslashUIndex = result.indexOf(BACKSLASH_U, start);
            int tildeUIndex = result.indexOf(TILDE_U, start);
            if (tildeUIndex < 0 && backslashUIndex < 0) break;
            int unicodeStrIdx = tildeUIndex < 0 ? backslashUIndex : (backslashUIndex < 0 ? tildeUIndex : Math.min(backslashUIndex, tildeUIndex));
            TryParseResult tryParse = UnicodeEscapeReplacer.tryParse(result, unicodeStrIdx + 2);
            start = unicodeStrIdx + 1;
            if (unicodeStrIdx > 0 && (result.charAt(unicodeStrIdx - 1) == '~' || result.charAt(unicodeStrIdx - 1) == '\\') || tryParse.codePoint <= 0) continue;
            char[] chars = Character.toChars(tryParse.codePoint);
            result = UnicodeEscapeReplacer.replace(result, chars, unicodeStrIdx, tryParse.length + 2);
        }
        return result;
    }

    private static String replace(String s, char[] value, int unicodeStrIdx, int length) {
        String left = s.substring(0, unicodeStrIdx);
        int end = Math.min(s.length(), unicodeStrIdx + length);
        String right = s.substring(end);
        return left + String.valueOf(value) + right;
    }

    private static boolean isValidRange(int value) {
        return value >= 0x100000 && value <= 0x10FFFF || value >= 65536 && value <= 1048575 || value >= 0 && value <= 55295 || value >= 57344 && value <= 65535;
    }

    private static boolean hasEnoughDigits(String s, int idx, int n) {
        int i;
        char[] chars = s.toCharArray();
        for (i = 0; i < n && idx + i < s.length(); ++i) {
            char c = chars[idx + i];
            if (Character.isDigit(c) || "abcdefABCDEF".indexOf(c) > -1) continue;
            return false;
        }
        return i == n;
    }

    private static TryParseResult tryParse(String str, int idx) {
        int value;
        if (UnicodeEscapeReplacer.hasEnoughDigits(str, idx, 6) && UnicodeEscapeReplacer.isValidRange(value = Integer.parseInt(str.substring(idx, idx + 6), 16))) {
            return new TryParseResult(value, 6);
        }
        if (UnicodeEscapeReplacer.hasEnoughDigits(str, idx, 5) && UnicodeEscapeReplacer.isValidRange(value = Integer.parseInt(str.substring(idx, idx + 5), 16))) {
            return new TryParseResult(value, 5);
        }
        if (UnicodeEscapeReplacer.hasEnoughDigits(str, idx, 4) && UnicodeEscapeReplacer.isValidRange(value = Integer.parseInt(str.substring(idx, idx + 4), 16))) {
            return new TryParseResult(value, 4);
        }
        return new TryParseResult(0, 4);
    }

    private static class TryParseResult {
        final int codePoint;
        final int length;

        private TryParseResult(int codePoint, int length) {
            this.codePoint = codePoint;
            this.length = length;
        }
    }
}

