/*
 * Decompiled with CFR 0.152.
 */
package uk.modl.transforms;

import io.vavr.collection.LinkedHashMap;
import io.vavr.collection.LinkedHashSet;
import io.vavr.collection.Map;
import io.vavr.collection.Set;
import io.vavr.collection.Vector;
import io.vavr.control.Option;
import org.apache.commons.lang3.StringUtils;
import uk.modl.ancestry.Ancestry;
import uk.modl.model.ArrayItem;
import uk.modl.transforms.StarClassTransform;
import uk.modl.transforms.StarMethodTransform;

public final class TransformationContext {
    public static final int VERSION = 1;
    public static final boolean STAR_LOAD_IMMUTABLE = false;
    public static final boolean STAR_CLASS_IMMUTABLE = false;
    private final Ancestry ancestry;
    private final int version;
    private final boolean starLoadImmutable;
    private final boolean starClassImmutable;
    private final Vector<ArrayItem> objectIndex;
    private final Vector<String> filesLoaded;
    private final Set<StarMethodTransform.MethodInstruction> methods;
    private final Map<String, StarMethodTransform.MethodInstruction> methodsById;
    private final Map<String, StarMethodTransform.MethodInstruction> methodsByName;
    private final Set<StarClassTransform.ClassInstruction> classes;
    private final Map<String, StarClassTransform.ClassInstruction> classesById;
    private final Map<String, StarClassTransform.ClassInstruction> classesByName;

    public static TransformationContext emptyCtx() {
        return new TransformationContext(new Ancestry(), 1, false, false, (Vector<ArrayItem>)Vector.empty(), (Vector<String>)Vector.empty(), (Set<StarMethodTransform.MethodInstruction>)LinkedHashSet.empty(), (Map<String, StarMethodTransform.MethodInstruction>)LinkedHashMap.empty(), (Map<String, StarMethodTransform.MethodInstruction>)LinkedHashMap.empty(), (Set<StarClassTransform.ClassInstruction>)LinkedHashSet.empty(), (Map<String, StarClassTransform.ClassInstruction>)LinkedHashMap.empty(), (Map<String, StarClassTransform.ClassInstruction>)LinkedHashMap.empty());
    }

    public TransformationContext addFilesLoaded(Vector<String> filenames) {
        return this.withFilesLoaded((Vector<String>)filenames.appendAll(this.filesLoaded));
    }

    public TransformationContext addMethodInstruction(StarMethodTransform.MethodInstruction mi) {
        if (this.methodsById.containsKey((Object)mi.getId()) || this.methodsByName.containsKey((Object)mi.getId())) {
            throw new RuntimeException("Duplicate method name or id: " + mi.getId());
        }
        if (this.methodsById.containsKey((Object)mi.getName()) || this.methodsByName.containsKey((Object)mi.getName())) {
            throw new RuntimeException("Duplicate method name or id: " + mi.getName());
        }
        Set updatedMethods = this.methods.add((Object)mi);
        Map updatedMethodsById = this.methodsById.put((Object)mi.getId(), (Object)mi);
        Map updatedMethodsByName = StringUtils.isNotEmpty((CharSequence)mi.getName()) ? this.methodsByName.put((Object)mi.getName(), (Object)mi) : this.methodsByName;
        return this.withMethods((Set<StarMethodTransform.MethodInstruction>)updatedMethods).withMethodsById((Map<String, StarMethodTransform.MethodInstruction>)updatedMethodsById).withMethodsByName((Map<String, StarMethodTransform.MethodInstruction>)updatedMethodsByName);
    }

    public TransformationContext addClassInstruction(StarClassTransform.ClassInstruction ci) {
        if (this.starClassImmutable) {
            throw new RuntimeException("Already defined *class as final.");
        }
        if (this.classesById.containsKey((Object)ci.getId()) || this.classesByName.containsKey((Object)ci.getId()) || this.classesById.containsKey((Object)ci.getName()) || this.classesByName.containsKey((Object)ci.getName())) {
            throw new RuntimeException("Class name or id already defined - cannot redefine: " + ci.getId() + ", " + ci.getName());
        }
        Set updatedClasses = this.classes.add((Object)ci);
        Map updatedClassesById = this.classesById.put((Object)ci.getId(), (Object)ci);
        Map updatedClassesByName = StringUtils.isNotEmpty((CharSequence)ci.getName()) ? this.classesByName.put((Object)ci.getName(), (Object)ci) : this.classesByName;
        return this.withClasses((Set<StarClassTransform.ClassInstruction>)updatedClasses).withClassesById((Map<String, StarClassTransform.ClassInstruction>)updatedClassesById).withClassesByName((Map<String, StarClassTransform.ClassInstruction>)updatedClassesByName);
    }

    public Option<StarClassTransform.ClassInstruction> getClassByNameOrId(String idOrName) {
        return this.classesById.get((Object)idOrName).orElse(() -> this.classesByName.get((Object)idOrName));
    }

    public Option<StarMethodTransform.MethodInstruction> getMethodByNameOrId(String idOrName) {
        return this.methodsById.get((Object)idOrName).orElse(() -> this.methodsByName.get((Object)idOrName));
    }

    private TransformationContext(Ancestry ancestry, int version, boolean starLoadImmutable, boolean starClassImmutable, Vector<ArrayItem> objectIndex, Vector<String> filesLoaded, Set<StarMethodTransform.MethodInstruction> methods, Map<String, StarMethodTransform.MethodInstruction> methodsById, Map<String, StarMethodTransform.MethodInstruction> methodsByName, Set<StarClassTransform.ClassInstruction> classes, Map<String, StarClassTransform.ClassInstruction> classesById, Map<String, StarClassTransform.ClassInstruction> classesByName) {
        this.ancestry = ancestry;
        this.version = version;
        this.starLoadImmutable = starLoadImmutable;
        this.starClassImmutable = starClassImmutable;
        this.objectIndex = objectIndex;
        this.filesLoaded = filesLoaded;
        this.methods = methods;
        this.methodsById = methodsById;
        this.methodsByName = methodsByName;
        this.classes = classes;
        this.classesById = classesById;
        this.classesByName = classesByName;
    }

    public static TransformationContext of(Ancestry ancestry, int version, boolean starLoadImmutable, boolean starClassImmutable, Vector<ArrayItem> objectIndex, Vector<String> filesLoaded, Set<StarMethodTransform.MethodInstruction> methods, Map<String, StarMethodTransform.MethodInstruction> methodsById, Map<String, StarMethodTransform.MethodInstruction> methodsByName, Set<StarClassTransform.ClassInstruction> classes, Map<String, StarClassTransform.ClassInstruction> classesById, Map<String, StarClassTransform.ClassInstruction> classesByName) {
        return new TransformationContext(ancestry, version, starLoadImmutable, starClassImmutable, objectIndex, filesLoaded, methods, methodsById, methodsByName, classes, classesById, classesByName);
    }

    public Ancestry getAncestry() {
        return this.ancestry;
    }

    public int getVersion() {
        return this.version;
    }

    public boolean isStarLoadImmutable() {
        return this.starLoadImmutable;
    }

    public boolean isStarClassImmutable() {
        return this.starClassImmutable;
    }

    public Vector<ArrayItem> getObjectIndex() {
        return this.objectIndex;
    }

    public Vector<String> getFilesLoaded() {
        return this.filesLoaded;
    }

    public Set<StarMethodTransform.MethodInstruction> getMethods() {
        return this.methods;
    }

    public Map<String, StarMethodTransform.MethodInstruction> getMethodsById() {
        return this.methodsById;
    }

    public Map<String, StarMethodTransform.MethodInstruction> getMethodsByName() {
        return this.methodsByName;
    }

    public Set<StarClassTransform.ClassInstruction> getClasses() {
        return this.classes;
    }

    public Map<String, StarClassTransform.ClassInstruction> getClassesById() {
        return this.classesById;
    }

    public Map<String, StarClassTransform.ClassInstruction> getClassesByName() {
        return this.classesByName;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TransformationContext)) {
            return false;
        }
        TransformationContext other = (TransformationContext)o;
        Ancestry this$ancestry = this.getAncestry();
        Ancestry other$ancestry = other.getAncestry();
        if (this$ancestry == null ? other$ancestry != null : !this$ancestry.equals(other$ancestry)) {
            return false;
        }
        if (this.getVersion() != other.getVersion()) {
            return false;
        }
        if (this.isStarLoadImmutable() != other.isStarLoadImmutable()) {
            return false;
        }
        if (this.isStarClassImmutable() != other.isStarClassImmutable()) {
            return false;
        }
        Vector<ArrayItem> this$objectIndex = this.getObjectIndex();
        Vector<ArrayItem> other$objectIndex = other.getObjectIndex();
        if (this$objectIndex == null ? other$objectIndex != null : !this$objectIndex.equals(other$objectIndex)) {
            return false;
        }
        Vector<String> this$filesLoaded = this.getFilesLoaded();
        Vector<String> other$filesLoaded = other.getFilesLoaded();
        if (this$filesLoaded == null ? other$filesLoaded != null : !this$filesLoaded.equals(other$filesLoaded)) {
            return false;
        }
        Set<StarMethodTransform.MethodInstruction> this$methods = this.getMethods();
        Set<StarMethodTransform.MethodInstruction> other$methods = other.getMethods();
        if (this$methods == null ? other$methods != null : !this$methods.equals(other$methods)) {
            return false;
        }
        Map<String, StarMethodTransform.MethodInstruction> this$methodsById = this.getMethodsById();
        Map<String, StarMethodTransform.MethodInstruction> other$methodsById = other.getMethodsById();
        if (this$methodsById == null ? other$methodsById != null : !this$methodsById.equals(other$methodsById)) {
            return false;
        }
        Map<String, StarMethodTransform.MethodInstruction> this$methodsByName = this.getMethodsByName();
        Map<String, StarMethodTransform.MethodInstruction> other$methodsByName = other.getMethodsByName();
        if (this$methodsByName == null ? other$methodsByName != null : !this$methodsByName.equals(other$methodsByName)) {
            return false;
        }
        Set<StarClassTransform.ClassInstruction> this$classes = this.getClasses();
        Set<StarClassTransform.ClassInstruction> other$classes = other.getClasses();
        if (this$classes == null ? other$classes != null : !this$classes.equals(other$classes)) {
            return false;
        }
        Map<String, StarClassTransform.ClassInstruction> this$classesById = this.getClassesById();
        Map<String, StarClassTransform.ClassInstruction> other$classesById = other.getClassesById();
        if (this$classesById == null ? other$classesById != null : !this$classesById.equals(other$classesById)) {
            return false;
        }
        Map<String, StarClassTransform.ClassInstruction> this$classesByName = this.getClassesByName();
        Map<String, StarClassTransform.ClassInstruction> other$classesByName = other.getClassesByName();
        return !(this$classesByName == null ? other$classesByName != null : !this$classesByName.equals(other$classesByName));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Ancestry $ancestry = this.getAncestry();
        result = result * 59 + ($ancestry == null ? 43 : $ancestry.hashCode());
        result = result * 59 + this.getVersion();
        result = result * 59 + (this.isStarLoadImmutable() ? 79 : 97);
        result = result * 59 + (this.isStarClassImmutable() ? 79 : 97);
        Vector<ArrayItem> $objectIndex = this.getObjectIndex();
        result = result * 59 + ($objectIndex == null ? 43 : $objectIndex.hashCode());
        Vector<String> $filesLoaded = this.getFilesLoaded();
        result = result * 59 + ($filesLoaded == null ? 43 : $filesLoaded.hashCode());
        Set<StarMethodTransform.MethodInstruction> $methods = this.getMethods();
        result = result * 59 + ($methods == null ? 43 : $methods.hashCode());
        Map<String, StarMethodTransform.MethodInstruction> $methodsById = this.getMethodsById();
        result = result * 59 + ($methodsById == null ? 43 : $methodsById.hashCode());
        Map<String, StarMethodTransform.MethodInstruction> $methodsByName = this.getMethodsByName();
        result = result * 59 + ($methodsByName == null ? 43 : $methodsByName.hashCode());
        Set<StarClassTransform.ClassInstruction> $classes = this.getClasses();
        result = result * 59 + ($classes == null ? 43 : $classes.hashCode());
        Map<String, StarClassTransform.ClassInstruction> $classesById = this.getClassesById();
        result = result * 59 + ($classesById == null ? 43 : $classesById.hashCode());
        Map<String, StarClassTransform.ClassInstruction> $classesByName = this.getClassesByName();
        result = result * 59 + ($classesByName == null ? 43 : $classesByName.hashCode());
        return result;
    }

    public String toString() {
        return "TransformationContext(ancestry=" + this.getAncestry() + ", version=" + this.getVersion() + ", starLoadImmutable=" + this.isStarLoadImmutable() + ", starClassImmutable=" + this.isStarClassImmutable() + ", objectIndex=" + this.getObjectIndex() + ", filesLoaded=" + this.getFilesLoaded() + ", methods=" + this.getMethods() + ", methodsById=" + this.getMethodsById() + ", methodsByName=" + this.getMethodsByName() + ", classes=" + this.getClasses() + ", classesById=" + this.getClassesById() + ", classesByName=" + this.getClassesByName() + ")";
    }

    public TransformationContext withAncestry(Ancestry ancestry) {
        return this.ancestry == ancestry ? this : new TransformationContext(ancestry, this.version, this.starLoadImmutable, this.starClassImmutable, this.objectIndex, this.filesLoaded, this.methods, this.methodsById, this.methodsByName, this.classes, this.classesById, this.classesByName);
    }

    public TransformationContext withVersion(int version) {
        return this.version == version ? this : new TransformationContext(this.ancestry, version, this.starLoadImmutable, this.starClassImmutable, this.objectIndex, this.filesLoaded, this.methods, this.methodsById, this.methodsByName, this.classes, this.classesById, this.classesByName);
    }

    public TransformationContext withStarLoadImmutable(boolean starLoadImmutable) {
        return this.starLoadImmutable == starLoadImmutable ? this : new TransformationContext(this.ancestry, this.version, starLoadImmutable, this.starClassImmutable, this.objectIndex, this.filesLoaded, this.methods, this.methodsById, this.methodsByName, this.classes, this.classesById, this.classesByName);
    }

    public TransformationContext withStarClassImmutable(boolean starClassImmutable) {
        return this.starClassImmutable == starClassImmutable ? this : new TransformationContext(this.ancestry, this.version, this.starLoadImmutable, starClassImmutable, this.objectIndex, this.filesLoaded, this.methods, this.methodsById, this.methodsByName, this.classes, this.classesById, this.classesByName);
    }

    public TransformationContext withObjectIndex(Vector<ArrayItem> objectIndex) {
        return this.objectIndex == objectIndex ? this : new TransformationContext(this.ancestry, this.version, this.starLoadImmutable, this.starClassImmutable, objectIndex, this.filesLoaded, this.methods, this.methodsById, this.methodsByName, this.classes, this.classesById, this.classesByName);
    }

    public TransformationContext withFilesLoaded(Vector<String> filesLoaded) {
        return this.filesLoaded == filesLoaded ? this : new TransformationContext(this.ancestry, this.version, this.starLoadImmutable, this.starClassImmutable, this.objectIndex, filesLoaded, this.methods, this.methodsById, this.methodsByName, this.classes, this.classesById, this.classesByName);
    }

    public TransformationContext withMethods(Set<StarMethodTransform.MethodInstruction> methods) {
        return this.methods == methods ? this : new TransformationContext(this.ancestry, this.version, this.starLoadImmutable, this.starClassImmutable, this.objectIndex, this.filesLoaded, methods, this.methodsById, this.methodsByName, this.classes, this.classesById, this.classesByName);
    }

    public TransformationContext withMethodsById(Map<String, StarMethodTransform.MethodInstruction> methodsById) {
        return this.methodsById == methodsById ? this : new TransformationContext(this.ancestry, this.version, this.starLoadImmutable, this.starClassImmutable, this.objectIndex, this.filesLoaded, this.methods, methodsById, this.methodsByName, this.classes, this.classesById, this.classesByName);
    }

    public TransformationContext withMethodsByName(Map<String, StarMethodTransform.MethodInstruction> methodsByName) {
        return this.methodsByName == methodsByName ? this : new TransformationContext(this.ancestry, this.version, this.starLoadImmutable, this.starClassImmutable, this.objectIndex, this.filesLoaded, this.methods, this.methodsById, methodsByName, this.classes, this.classesById, this.classesByName);
    }

    public TransformationContext withClasses(Set<StarClassTransform.ClassInstruction> classes) {
        return this.classes == classes ? this : new TransformationContext(this.ancestry, this.version, this.starLoadImmutable, this.starClassImmutable, this.objectIndex, this.filesLoaded, this.methods, this.methodsById, this.methodsByName, classes, this.classesById, this.classesByName);
    }

    public TransformationContext withClassesById(Map<String, StarClassTransform.ClassInstruction> classesById) {
        return this.classesById == classesById ? this : new TransformationContext(this.ancestry, this.version, this.starLoadImmutable, this.starClassImmutable, this.objectIndex, this.filesLoaded, this.methods, this.methodsById, this.methodsByName, this.classes, classesById, this.classesByName);
    }

    public TransformationContext withClassesByName(Map<String, StarClassTransform.ClassInstruction> classesByName) {
        return this.classesByName == classesByName ? this : new TransformationContext(this.ancestry, this.version, this.starLoadImmutable, this.starClassImmutable, this.objectIndex, this.filesLoaded, this.methods, this.methodsById, this.methodsByName, this.classes, this.classesById, classesByName);
    }
}

