/*
 * Decompiled with CFR 0.152.
 */
package uk.modl.utils;

import java.util.LinkedHashMap;
import java.util.Map;
import uk.modl.utils.UnicodeEscapeReplacer;

public class StringEscapeReplacer {
    private static final Map<String, String> replacements = new LinkedHashMap<String, String>();

    public static String replace(String stringToTransform) {
        String result = UnicodeEscapeReplacer.convertUnicodeSequences(stringToTransform);
        block0: for (int i = 0; i < result.length(); ++i) {
            for (Map.Entry<String, String> replacement : replacements.entrySet()) {
                String key = replacement.getKey();
                if (!result.startsWith(key, i)) continue;
                String value = replacement.getValue();
                result = result.substring(0, i) + value + result.substring(i + key.length());
                continue block0;
            }
        }
        return result;
    }

    static {
        replacements.put("\\%", "%");
        replacements.put("~%", "%");
        replacements.put("~\\", "\\");
        replacements.put("\\\\", "\\");
        replacements.put("~~", "~");
        replacements.put("\\~", "~");
        replacements.put("~(", "(");
        replacements.put("\\(", "(");
        replacements.put("~)", ")");
        replacements.put("\\)", ")");
        replacements.put("~[", "[");
        replacements.put("\\[", "[");
        replacements.put("~]", "]");
        replacements.put("\\]", "]");
        replacements.put("~{", "{");
        replacements.put("\\{", "{");
        replacements.put("~}", "}");
        replacements.put("\\}", "}");
        replacements.put("~;", ";");
        replacements.put("\\;", ";");
        replacements.put("~:", ":");
        replacements.put("\\:", ":");
        replacements.put("~`", "`");
        replacements.put("\\`", "`");
        replacements.put("~\"", "\"");
        replacements.put("\\\"", "\"");
        replacements.put("~=", "=");
        replacements.put("\\=", "=");
        replacements.put("~/", "/");
        replacements.put("\\/", "/");
        replacements.put("<", "<");
        replacements.put("\\<", "<");
        replacements.put("~>", ">");
        replacements.put("\\>", ">");
        replacements.put("~&", "&");
        replacements.put("\\&", "&");
        replacements.put("!", "!");
        replacements.put("\\!", "!");
        replacements.put("~|", "|");
        replacements.put("\\|", "|");
        replacements.put("\\t", "\t");
        replacements.put("\\n", "\n");
        replacements.put("\\b", "\b");
        replacements.put("\\f", "\f");
        replacements.put("\\r", "\r");
    }
}

