/*
 * Decompiled with CFR 0.152.
 */
package uk.modl.transforms;

import io.vavr.Tuple;
import io.vavr.Tuple2;
import io.vavr.Tuple3;
import io.vavr.collection.Vector;
import io.vavr.control.Option;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.Scanner;
import lombok.NonNull;
import uk.modl.extractors.StarLoadExtractor;
import uk.modl.interpreter.Interpreter;
import uk.modl.model.Array;
import uk.modl.model.ArrayItem;
import uk.modl.model.Modl;
import uk.modl.model.Pair;
import uk.modl.model.Structure;
import uk.modl.parser.errors.StarLoadException;
import uk.modl.transforms.ReferencesTransform;
import uk.modl.transforms.TransformationContext;
import uk.modl.utils.SimpleCache;

public class StarLoadTransform {
    private static final String COULD_NOT_LOAD_RESOURCE = "Could not load resource: ";
    private static final SimpleCache<String, Modl> cache = new SimpleCache();

    private static Vector<StarLoadExtractor.LoadSet> extractFilenamesAndPairs(Pair p) {
        return new StarLoadExtractor().accept(p).getLoadSets();
    }

    private static Option<URL> toUrl(@NonNull String maybeUrl) {
        if (maybeUrl == null) {
            throw new NullPointerException("maybeUrl is marked non-null but is null");
        }
        try {
            return Option.of((Object)new URL(maybeUrl));
        }
        catch (Exception e) {
            try {
                return Option.of((Object)Paths.get(maybeUrl, new String[0]).toUri().toURL());
            }
            catch (MalformedURLException malformedURLException) {
                return Option.none();
            }
        }
    }

    private Tuple2<TransformationContext, Vector<Tuple3<Vector<String>, Vector<Modl>, Pair>>> convertFilesToModlObjectsAndPairs(TransformationContext ctx, Vector<StarLoadExtractor.LoadSet> list) {
        TransformationContext newCtx = ctx;
        Vector result = Vector.empty();
        for (StarLoadExtractor.LoadSet loadSet : list) {
            if (newCtx.isStarLoadImmutable()) {
                throw new RuntimeException("Cannot load multiple files after *LOAD instruction");
            }
            if (loadSet.getPair().getKey().startsWith("*L")) {
                newCtx = newCtx.withStarLoadImmutable(true);
            }
            Vector<StarLoadExtractor.FileSpec> filenames = loadSet.getFileSet();
            for (StarLoadExtractor.FileSpec spec : filenames) {
                Interpreter interpreter = new Interpreter();
                boolean cached = cache.contains(spec.getFilename());
                try {
                    Tuple2<StarLoadExtractor.FileSpec, String> contents;
                    Object fileToLoad;
                    TransformationContext interpreterContext;
                    Option<URL> originalUrl = ctx.getUrl();
                    if (cached && !spec.isForceLoad()) {
                        Object fileToLoad2;
                        if (ctx.getUrl().isDefined()) {
                            fileToLoad2 = new URL((URL)originalUrl.get(), spec.getFilename());
                            interpreterContext = newCtx.withUrl((Option<URL>)Option.of(fileToLoad2));
                        } else {
                            fileToLoad2 = StarLoadTransform.toUrl(spec.getFilename());
                            interpreterContext = newCtx.withUrl((Option<URL>)fileToLoad2);
                        }
                        Tuple2 cachedModl = Tuple.of((Object)spec, (Object)cache.get(spec.getFilename()));
                        Tuple2<TransformationContext, Modl> interpreted = interpreter.apply(interpreterContext, (Modl)cachedModl._2);
                        newCtx = (TransformationContext)interpreted._1;
                        result = result.append((Object)Tuple.of((Object)Vector.of((Object)((StarLoadExtractor.FileSpec)cachedModl._1).getFilename()), (Object)Vector.of((Object)((Modl)cachedModl._2)), (Object)loadSet.getPair()));
                        continue;
                    }
                    if (originalUrl.isDefined()) {
                        fileToLoad = new URL((URL)originalUrl.get(), spec.getFilename());
                        contents = this.getFileContents(spec, (URL)ctx.getUrl().get());
                        interpreterContext = newCtx.withUrl((Option<URL>)Option.of(fileToLoad));
                    } else {
                        contents = this.getFileContents(spec);
                        fileToLoad = StarLoadTransform.toUrl(spec.getFilename());
                        interpreterContext = newCtx.withUrl((Option<URL>)fileToLoad);
                    }
                    Modl parsed = interpreter.parse(ctx, (String)contents._2);
                    Tuple2<TransformationContext, Modl> interpreted = interpreter.apply(interpreterContext.withNestingLevel(interpreterContext.getNestingLevel() + 1), parsed);
                    newCtx = ((TransformationContext)interpreted._1).withUrl(originalUrl).withNestingLevel(((TransformationContext)interpreted._1).getNestingLevel() - 1);
                    result = result.append((Object)Tuple.of((Object)Vector.of((Object)((StarLoadExtractor.FileSpec)contents._1).getFilename()), (Object)Vector.of((Object)((Modl)interpreted._2)), (Object)loadSet.getPair()));
                    cache.put(((StarLoadExtractor.FileSpec)contents._1).getFilename(), parsed);
                }
                catch (StarLoadException e) {
                    if (cached) {
                        Tuple2 cachedModl = Tuple.of((Object)spec, (Object)cache.get(spec.getFilename()));
                        Tuple2<TransformationContext, Modl> interpreted = interpreter.apply(newCtx, (Modl)cachedModl._2);
                        newCtx = (TransformationContext)interpreted._1;
                        result = result.append((Object)Tuple.of((Object)Vector.of((Object)((StarLoadExtractor.FileSpec)cachedModl._1).getFilename()), (Object)Vector.of((Object)((Modl)cachedModl._2)), (Object)loadSet.getPair()));
                        continue;
                    }
                    throw e;
                }
                catch (MalformedURLException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return Tuple.of((Object)newCtx, (Object)result);
    }

    public Tuple2<StarLoadExtractor.FileSpec, String> getFileContents(StarLoadExtractor.FileSpec spec) {
        try {
            if (spec.getFilename().startsWith("http")) {
                URL url = new URL(spec.getFilename());
                return Tuple.of((Object)spec, (Object)this.loadFromUrl(url));
            }
            if (Files.exists(Paths.get(spec.getFilename(), new String[0]), new LinkOption[0])) {
                return Tuple.of((Object)spec, (Object)String.join((CharSequence)"\n", Files.readAllLines(Paths.get(spec.getFilename(), new String[0]))));
            }
        }
        catch (Exception e) {
            throw new StarLoadException(COULD_NOT_LOAD_RESOURCE + e.getMessage());
        }
        throw new StarLoadException(COULD_NOT_LOAD_RESOURCE + spec.getFilename());
    }

    private String loadFromUrl(URL url) throws IOException {
        try (InputStream urlStream = url.openStream();){
            Scanner scanner = new Scanner(urlStream, StandardCharsets.UTF_8.name());
            try {
                String string = scanner.useDelimiter("\\A").next();
                scanner.close();
                return string;
            }
            catch (Throwable throwable) {
                try {
                    scanner.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
    }

    public Tuple2<StarLoadExtractor.FileSpec, String> getFileContents(StarLoadExtractor.FileSpec spec, URL contextUrl) {
        try {
            URL url = new URL(contextUrl, spec.getFilename());
            return Tuple.of((Object)spec, (Object)this.loadFromUrl(url));
        }
        catch (Exception e) {
            throw new StarLoadException(COULD_NOT_LOAD_RESOURCE + e.getMessage());
        }
    }

    public Tuple2<TransformationContext, Structure> apply(TransformationContext ctx, Structure s) {
        Pair rawPair;
        TransformationContext newCtx = ctx;
        if (s instanceof Pair && StarLoadExtractor.isLoadInstruction((rawPair = (Pair)s).getKey())) {
            Tuple2<TransformationContext, Structure> refsResult = new ReferencesTransform().apply(newCtx, rawPair);
            newCtx = (TransformationContext)refsResult._1;
            Pair p = (Pair)refsResult._2;
            Vector<StarLoadExtractor.LoadSet> loadSets = StarLoadTransform.extractFilenamesAndPairs(p);
            Vector filenames = loadSets.flatMap(set -> set.getFileSet().map(StarLoadExtractor.FileSpec::getFilename));
            newCtx = newCtx.addFilesLoaded((Vector<String>)filenames);
            Tuple2<TransformationContext, Vector<Tuple3<Vector<String>, Vector<Modl>, Pair>>> result = this.convertFilesToModlObjectsAndPairs(newCtx, loadSets);
            return Tuple.of((Object)((TransformationContext)result._1), (Object)new StarLoadMutator((Vector<Tuple3<Vector<String>, Vector<Modl>, Pair>>)((Vector)result._2)).accept(p, ctx));
        }
        return Tuple.of((Object)newCtx, (Object)s);
    }

    private static class StarLoadMutator {
        private final Vector<Tuple3<Vector<String>, Vector<Modl>, Pair>> loadedModlObjects;

        public Pair accept(Pair pair, TransformationContext ctx) {
            Option maybeFoundPair = this.loadedModlObjects.findLast(tuple3 -> pair.equals(tuple3._3));
            return (Pair)maybeFoundPair.map(p -> this.replace(pair, (Tuple3<Vector<String>, Vector<Modl>, Pair>)p, ctx)).getOrElse((Object)pair);
        }

        private Pair replace(Pair p, Tuple3<Vector<String>, Vector<Modl>, Pair> replacement, TransformationContext ctx) {
            if (p.equals(replacement._3)) {
                Vector arrayItems = ((Vector)replacement._2).flatMap(m -> m.getStructures().filter(structure -> structure instanceof ArrayItem).map(structure -> (ArrayItem)((Object)structure)));
                return p.with(ctx.getAncestry(), Array.of(ctx.getAncestry(), p, (Vector<ArrayItem>)arrayItems));
            }
            return p;
        }

        public StarLoadMutator(Vector<Tuple3<Vector<String>, Vector<Modl>, Pair>> loadedModlObjects) {
            this.loadedModlObjects = loadedModlObjects;
        }
    }
}

