/*
 * Decompiled with CFR 0.152.
 */
package uk.modl.model;

import io.vavr.collection.Vector;
import lombok.NonNull;
import uk.modl.ancestry.Ancestry;
import uk.modl.ancestry.Child;
import uk.modl.ancestry.Parent;
import uk.modl.model.ValueItem;
import uk.modl.utils.IDSource;

public final class ValueConditionalReturn
implements Parent,
Child {
    private final long id;
    @NonNull
    private final Vector<ValueItem> items;

    public static ValueConditionalReturn of(Ancestry ancestry, Parent parent, Vector<ValueItem> items) {
        ValueConditionalReturn child = ValueConditionalReturn.of(IDSource.nextId(), items);
        ancestry.add(parent, child);
        return child;
    }

    public ValueConditionalReturn with(Ancestry ancestry, Vector<ValueItem> items) {
        ValueConditionalReturn child = ValueConditionalReturn.of(this.id, items);
        ancestry.replaceChild(this, child);
        return child;
    }

    private ValueConditionalReturn(long id, @NonNull Vector<ValueItem> items) {
        if (items == null) {
            throw new NullPointerException("items is marked non-null but is null");
        }
        this.id = id;
        this.items = items;
    }

    public static ValueConditionalReturn of(long id, @NonNull Vector<ValueItem> items) {
        return new ValueConditionalReturn(id, items);
    }

    @Override
    public long getId() {
        return this.id;
    }

    @NonNull
    public Vector<ValueItem> getItems() {
        return this.items;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ValueConditionalReturn)) {
            return false;
        }
        ValueConditionalReturn other = (ValueConditionalReturn)o;
        return this.getId() == other.getId();
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $id = this.getId();
        result = result * 59 + (int)($id >>> 32 ^ $id);
        return result;
    }

    public String toString() {
        return "ValueConditionalReturn(items=" + this.getItems() + ")";
    }
}

