/*
 * Decompiled with CFR 0.152.
 */
package uk.modl.model;

import io.vavr.collection.Vector;
import lombok.NonNull;
import uk.modl.ancestry.Ancestry;
import uk.modl.ancestry.Child;
import uk.modl.ancestry.Parent;
import uk.modl.model.MapItem;
import uk.modl.utils.IDSource;

public final class MapConditionalReturn
implements Parent,
Child {
    private final long id;
    @NonNull
    private final Vector<MapItem> items;

    public static MapConditionalReturn of(Ancestry ancestry, Parent parent, Vector<MapItem> items) {
        MapConditionalReturn child = MapConditionalReturn.of(IDSource.nextId(), items);
        ancestry.add(parent, child);
        return child;
    }

    public MapConditionalReturn with(Ancestry ancestry, Vector<MapItem> items) {
        MapConditionalReturn child = MapConditionalReturn.of(this.id, items);
        ancestry.replaceChild(this, child);
        return child;
    }

    private MapConditionalReturn(long id, @NonNull Vector<MapItem> items) {
        if (items == null) {
            throw new NullPointerException("items is marked non-null but is null");
        }
        this.id = id;
        this.items = items;
    }

    public static MapConditionalReturn of(long id, @NonNull Vector<MapItem> items) {
        return new MapConditionalReturn(id, items);
    }

    @Override
    public long getId() {
        return this.id;
    }

    @NonNull
    public Vector<MapItem> getItems() {
        return this.items;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MapConditionalReturn)) {
            return false;
        }
        MapConditionalReturn other = (MapConditionalReturn)o;
        return this.getId() == other.getId();
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $id = this.getId();
        result = result * 59 + (int)($id >>> 32 ^ $id);
        return result;
    }

    public String toString() {
        return "MapConditionalReturn(items=" + this.getItems() + ")";
    }
}

