/*
 * Decompiled with CFR 0.152.
 */
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.vavr.Tuple2;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import uk.modl.interpreter.Interpreter;
import uk.modl.model.Modl;
import uk.modl.transforms.JacksonJsonNodeTransform;
import uk.modl.transforms.TransformationContext;

public class Interpret {
    public static void main(String ... args) {
        if (args.length == 0) {
            System.out.println("Usage: java -cp ./build/libs/interpreter-<version>.jar <modl-file-name> [modl-file-name] ...");
        }
        int sum = Arrays.stream(args).mapToInt(filename -> {
            System.out.println("Processing file: " + filename);
            try {
                Path path = Paths.get(filename, new String[0]);
                String modlString = String.join((CharSequence)"\n", Files.readAllLines(path));
                Interpreter interpreter = new Interpreter();
                TransformationContext ctx = TransformationContext.baseCtx(new URL(path.toUri().toASCIIString()));
                Tuple2<TransformationContext, Modl> interpreted = interpreter.apply(ctx, modlString);
                JsonNode json = new JacksonJsonNodeTransform(ctx).apply((Modl)interpreted._2);
                String result = new ObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString((Object)json);
                System.out.println(result);
            }
            catch (Throwable e) {
                System.err.println(e.getMessage());
                return 1;
            }
            System.out.println("Finished file: " + filename);
            System.out.println();
            return 0;
        }).sum();
        System.exit(sum);
    }
}

