/*
 * Decompiled with CFR 0.152.
 */
package uk.modl.modlObject;

import uk.modl.modlObject.ModlObject;
import uk.modl.modlObject.ModlValue;

public class ModlObjectTreeWalker {
    private ModlObject modlObject;

    public ModlObjectTreeWalker(ModlObject modlObject) {
        this.modlObject = modlObject;
    }

    public void walk(Visitor visitor) {
        for (ModlObject.Structure structure : this.modlObject.getStructures()) {
            visitor.visit(structure);
            this.walk(structure, visitor);
        }
    }

    public void walk(ModlValue structure, Visitor visitor) {
        if (structure instanceof ModlObject.Map) {
            ModlObject.Map map = (ModlObject.Map)structure;
            for (ModlObject.Pair pair : map.getPairs()) {
                visitor.visit(pair);
                this.walk(pair, visitor);
            }
        }
        if (structure instanceof ModlObject.Pair) {
            ModlObject.Pair pair = (ModlObject.Pair)structure;
            visitor.visit(pair.getKey());
            visitor.visit(pair.getValue());
            this.walk(pair.getModlValue(), visitor);
        }
        if (structure instanceof ModlObject.Array) {
            ModlObject.Array array = (ModlObject.Array)structure;
            for (ModlValue value : array.values) {
                visitor.visit(value);
                this.walk(value, visitor);
            }
        }
        if (structure instanceof ModlObject.Number) {
            ModlObject.Number number = (ModlObject.Number)structure;
            visitor.visit(number);
        }
        if (structure instanceof ModlObject.String) {
            ModlObject.String str = (ModlObject.String)structure;
            visitor.visit(str);
        }
        if (structure instanceof ModlObject.True) {
            ModlObject.True t = (ModlObject.True)structure;
            visitor.visit(t);
        }
        if (structure instanceof ModlObject.False) {
            ModlObject.False f = (ModlObject.False)structure;
            visitor.visit(f);
        }
        if (structure instanceof ModlObject.Null) {
            ModlObject.Null n = (ModlObject.Null)structure;
            visitor.visit(n);
        }
    }

    public static interface Visitor {
        public void visit(Object var1);
    }
}

