/*
 * Decompiled with CFR 0.152.
 */
package uk.modl.interpreter;

import java.io.UnsupportedEncodingException;
import java.net.IDN;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.text.WordUtils;

class VariableMethods {
    static Pattern STRING = Pattern.compile("(\\w+)");
    private Map<String, TaskRunner> methods = null;

    private void initialiseMethods() {
        this.methods = new HashMap<String, TaskRunner>();
        this.addTrimTask();
        this.addUpperCaseTask();
        this.addDownCaseTask();
        this.addInitCapsTask();
        this.addUrlEncodeTask();
        this.addSentenceTask();
        this.addReplaceTask();
        this.addPunycodeTask();
    }

    private void addTrimTask() {
        TaskRunner trimTask = new TaskRunner(){

            @Override
            public void run() {
                if (this.parameter == null) {
                    this.result = null;
                } else {
                    String[] split = this.parameter.split(",");
                    String subject = split[0];
                    String trim = split[1];
                    int indexOfTrim = subject.indexOf(trim);
                    this.result = subject.substring(0, indexOfTrim);
                }
            }
        };
        this.methods.put("t", trimTask);
        this.methods.put("trim", trimTask);
    }

    private void addUpperCaseTask() {
        TaskRunner upperCaseTask = new TaskRunner(){

            @Override
            public void run() {
                this.result = this.parameter == null ? null : this.parameter.toUpperCase();
            }
        };
        this.methods.put("u", upperCaseTask);
        this.methods.put("uupcase", upperCaseTask);
    }

    private void addSentenceTask() {
        TaskRunner sentenceTask = new TaskRunner(){

            @Override
            public void run() {
                this.result = this.parameter == null ? null : VariableMethods.this.makeSentence(this.parameter);
            }
        };
        this.methods.put("s", sentenceTask);
        this.methods.put("sentence", sentenceTask);
    }

    private void addDownCaseTask() {
        TaskRunner downCaseTask = new TaskRunner(){

            @Override
            public void run() {
                this.result = this.parameter == null ? null : this.parameter.toLowerCase();
            }
        };
        this.methods.put("d", downCaseTask);
        this.methods.put("downcase", downCaseTask);
    }

    private void addInitCapsTask() {
        TaskRunner task = new TaskRunner(){

            @Override
            public void run() {
                if (this.parameter == null) {
                    this.result = null;
                }
                this.result = WordUtils.capitalize((String)this.parameter);
            }
        };
        this.methods.put("i", task);
        this.methods.put("initcap", task);
    }

    private void addReplaceTask() {
        TaskRunner task = new TaskRunner(){

            @Override
            public void run() {
                if (this.parameter == null) {
                    this.result = null;
                } else {
                    String[] split = this.parameter.split(",");
                    String subject = split[0];
                    String search = split[1];
                    String replace = "";
                    if (split.length > 2) {
                        replace = split[2];
                    }
                    this.result = subject.replace(search, replace);
                }
            }
        };
        this.methods.put("r", task);
        this.methods.put("replace", task);
    }

    private void addUrlEncodeTask() {
        TaskRunner task = new TaskRunner(){

            @Override
            public void run() {
                if (this.parameter == null) {
                    this.result = null;
                } else {
                    try {
                        this.result = URLEncoder.encode(this.parameter, StandardCharsets.UTF_8.toString());
                    }
                    catch (UnsupportedEncodingException e) {
                        e.printStackTrace();
                        this.result = null;
                    }
                }
            }
        };
        this.methods.put("e", task);
        this.methods.put("urlencode", task);
    }

    private void addPunycodeTask() {
        TaskRunner task = new TaskRunner(){

            @Override
            public void run() {
                if (this.parameter == null) {
                    this.result = null;
                }
                this.result = VariableMethods.this.replacePunycode(this.parameter);
            }
        };
        this.methods.put("p", task);
        this.methods.put("punydecode", task);
    }

    String transform(String methodName, String input) {
        if (this.methods == null) {
            this.initialiseMethods();
        }
        TaskRunner taskRunner = this.methods.get(methodName);
        try {
            taskRunner.setParameter(input);
            taskRunner.run();
            return taskRunner.getResult();
        }
        catch (Exception e) {
            throw new RuntimeException("Can't call variable transform " + methodName + " : " + e);
        }
    }

    void addMethod(String shortName, TaskRunner taskRunner) {
        if (this.methods == null) {
            this.initialiseMethods();
        }
        this.methods.put(shortName, taskRunner);
    }

    private String makeSentence(String parameter) {
        String[] splits = parameter.split(" ");
        splits[0] = WordUtils.capitalize((String)splits[0]);
        StringBuilder ret = new StringBuilder();
        int count = 0;
        for (String s : splits) {
            if (count > 0) {
                ret.append(" ");
            }
            ++count;
            ret.append(s);
        }
        return ret.toString();
    }

    private String replacePunycode(String stringToTransform) {
        if (stringToTransform == null) {
            return null;
        }
        if (stringToTransform.startsWith("`") && stringToTransform.endsWith("`")) {
            stringToTransform = stringToTransform.substring(1, stringToTransform.length() - 1);
        }
        String originalString = stringToTransform;
        stringToTransform = "xn--" + stringToTransform;
        String newStringToTransform = IDN.toUnicode(stringToTransform);
        stringToTransform = newStringToTransform.equals(stringToTransform) ? originalString : newStringToTransform;
        return stringToTransform;
    }

    boolean isVariableMethod(String s) {
        Matcher matcher;
        if (this.methods == null) {
            this.initialiseMethods();
        }
        if ((matcher = STRING.matcher(s)).find() && matcher.groupCount() > 0) {
            String match = matcher.group(0);
            return this.methods.get(match) != null;
        }
        return false;
    }

    static abstract class TaskRunner
    implements Runnable {
        String parameter;
        String result;

        TaskRunner() {
        }

        void setParameter(String s) {
            this.parameter = s;
        }

        String getResult() {
            return this.result;
        }
    }
}

