/*
 * Decompiled with CFR 0.152.
 */
package uk.modl.modlObject;

import uk.modl.modlObject.ModlObject;
import uk.modl.modlObject.ModlValue;
import uk.modl.parser.RawModlObject;

public class ModlObjectTreeWalker {
    private ModlObject modlObject;

    public ModlObjectTreeWalker(ModlObject modlObject) {
        this.modlObject = modlObject;
    }

    public void walk(Visitor visitor) {
        for (ModlObject.Structure structure : this.modlObject.getStructures()) {
            visitor.visit(structure);
            this.walk(structure, visitor);
        }
    }

    public void walk(RawModlObject.ConditionTest conditionTest, Visitor visitor) {
        conditionTest.getSubConditionMap().forEach((k, v) -> {
            this.walk((RawModlObject.SubCondition)k, visitor);
            visitor.visit(v);
        });
    }

    public void walk(RawModlObject.Condition condition, Visitor visitor) {
        visitor.visit(condition);
        condition.getValues().forEach(modlValue -> this.walk((ModlValue)modlValue, visitor));
    }

    public void walk(RawModlObject.ConditionGroup conditionGroup, Visitor visitor) {
        conditionGroup.getConditionsTestList().forEach(visitor::visit);
    }

    public void walk(RawModlObject.SubCondition subCondition, Visitor visitor) {
        if (subCondition instanceof RawModlObject.Condition) {
            this.walk((RawModlObject.Condition)subCondition, visitor);
        }
        if (subCondition instanceof RawModlObject.ConditionGroup) {
            this.walk((RawModlObject.ConditionGroup)subCondition, visitor);
        }
    }

    public void walk(ModlValue structure, Visitor visitor) {
        Object n;
        if (structure instanceof ModlObject.Map) {
            ModlObject.Map map = (ModlObject.Map)structure;
            for (ModlObject.Pair pair : map.getPairs()) {
                visitor.visit(pair);
                this.walk(pair, visitor);
            }
        }
        if (structure instanceof ModlObject.Pair) {
            ModlObject.Pair pair = (ModlObject.Pair)structure;
            visitor.visit(pair.getKey());
            this.walk(pair.getModlValue(), visitor);
        }
        if (structure instanceof ModlObject.Array) {
            ModlObject.Array array = (ModlObject.Array)structure;
            for (ModlValue value2 : array.values) {
                visitor.visit(value2);
                this.walk(value2, visitor);
            }
        }
        if (structure instanceof ModlObject.Number) {
            ModlObject.Number number = (ModlObject.Number)structure;
            visitor.visit(number);
        }
        if (structure instanceof ModlObject.String) {
            ModlObject.String str = (ModlObject.String)structure;
            visitor.visit(str);
        }
        if (structure instanceof ModlObject.True) {
            ModlObject.True t = (ModlObject.True)structure;
            visitor.visit(t);
        }
        if (structure instanceof ModlObject.False) {
            ModlObject.False f = (ModlObject.False)structure;
            visitor.visit(f);
        }
        if (structure instanceof ModlObject.Null) {
            n = (ModlObject.Null)structure;
            visitor.visit(n);
        }
        if (structure instanceof RawModlObject.ValueConditional) {
            n = (RawModlObject.ValueConditional)structure;
            ((RawModlObject.ValueConditional)n).getConditionals().forEach((key, value) -> {
                this.walk((RawModlObject.ConditionTest)key, visitor);
                this.walk((ModlValue)value, visitor);
            });
        }
        if (structure instanceof RawModlObject.ArrayConditional) {
            n = (RawModlObject.ArrayConditional)structure;
            ((RawModlObject.ArrayConditional)n).getConditionals().forEach((k, v) -> {
                this.walk((RawModlObject.ConditionTest)k, visitor);
                this.walk((ModlValue)v, visitor);
            });
        }
        if (structure instanceof RawModlObject.ArrayConditionalReturn) {
            n = (RawModlObject.ArrayConditionalReturn)structure;
            ((ModlObject.Array)n).getValues().forEach(v -> this.walk((ModlValue)v, visitor));
        }
        if (structure instanceof RawModlObject.SubCondition) {
            n = (RawModlObject.SubCondition)((Object)structure);
            this.walk((RawModlObject.SubCondition)n, visitor);
        }
        if (structure instanceof RawModlObject.MapConditional) {
            n = (RawModlObject.MapConditional)structure;
            ((RawModlObject.MapConditional)n).getConditionals().forEach((k, v) -> {
                this.walk((RawModlObject.ConditionTest)k, visitor);
                v.getPairs().forEach(p -> this.walk((ModlValue)p, visitor));
            });
        }
        if (structure instanceof RawModlObject.TopLevelConditional) {
            n = (RawModlObject.TopLevelConditional)structure;
            ((RawModlObject.TopLevelConditional)n).getConditionals().forEach((k, v) -> {
                this.walk((RawModlObject.ConditionTest)k, visitor);
                this.walk((ModlValue)v, visitor);
            });
        }
        if (structure instanceof RawModlObject.TopLevelConditionalReturn) {
            n = (RawModlObject.TopLevelConditionalReturn)structure;
            ((ModlValue)n).getModlValues().forEach(v -> this.walk((ModlValue)v, visitor));
        }
        if (structure instanceof RawModlObject.ValueConditionalReturn) {
            n = (RawModlObject.ValueConditionalReturn)structure;
            ((RawModlObject.ValueConditionalReturn)n).getValues().forEach(v -> this.walk((ModlValue)v, visitor));
        }
    }

    public static interface Visitor {
        public void visit(Object var1);
    }
}

