/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.service.notify;

import java.net.URI;
import java.util.Optional;
import java.util.UUID;
import org.json.JSONObject;

public class SendEmailResponse {
    private final UUID notificationId;
    private final String reference;
    private final UUID templateId;
    private final int templateVersion;
    private final String templateUri;
    private final String body;
    private final String subject;
    private final String fromEmail;
    private final URI oneClickUnsubscribeURL;

    public SendEmailResponse(String response) {
        JSONObject data = new JSONObject(response);
        this.notificationId = UUID.fromString(data.getString("id"));
        this.reference = data.isNull("reference") ? null : data.getString("reference");
        JSONObject content = data.getJSONObject("content");
        this.body = content.getString("body");
        this.fromEmail = content.isNull("from_email") ? null : content.getString("from_email");
        this.subject = content.getString("subject");
        JSONObject template = data.getJSONObject("template");
        this.templateId = UUID.fromString(template.getString("id"));
        this.templateVersion = template.getInt("version");
        this.templateUri = template.getString("uri");
        this.oneClickUnsubscribeURL = data.isNull("one_click_unsubscribe_url") ? null : URI.create(data.getString("one_click_unsubscribe_url"));
    }

    public UUID getNotificationId() {
        return this.notificationId;
    }

    public Optional<String> getReference() {
        return Optional.ofNullable(this.reference);
    }

    public UUID getTemplateId() {
        return this.templateId;
    }

    public int getTemplateVersion() {
        return this.templateVersion;
    }

    public String getTemplateUri() {
        return this.templateUri;
    }

    public String getBody() {
        return this.body;
    }

    public String getSubject() {
        return this.subject;
    }

    public Optional<String> getFromEmail() {
        return Optional.ofNullable(this.fromEmail);
    }

    public Optional<URI> getOneClickUnsubscribeURL() {
        return Optional.ofNullable(this.oneClickUnsubscribeURL);
    }

    public String toString() {
        return "SendEmailResponse{notificationId=" + this.notificationId + ", reference='" + this.reference + '\'' + ", templateId=" + this.templateId + ", templateVersion=" + this.templateVersion + ", templateUri='" + this.templateUri + '\'' + ", body='" + this.body + '\'' + ", subject='" + this.subject + '\'' + ", fromEmail='" + this.fromEmail + '\'' + ", oneClickUnsubscribeURL=" + this.oneClickUnsubscribeURL + '}';
    }
}

