/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.service.notify;

import java.util.UUID;
import org.json.JSONObject;
import uk.gov.service.notify.LetterResponse;

public class SendLetterResponse
extends LetterResponse {
    private final UUID templateId;
    private final int templateVersion;
    private final String templateUri;
    private final String body;
    private final String subject;

    public SendLetterResponse(String response) {
        super(response);
        JSONObject content = this.getData().getJSONObject("content");
        this.body = this.tryToGetString(content, "body");
        this.subject = this.tryToGetString(content, "subject");
        JSONObject template = this.getData().getJSONObject("template");
        this.templateId = UUID.fromString(template.getString("id"));
        this.templateVersion = template.getInt("version");
        this.templateUri = template.getString("uri");
    }

    public UUID getTemplateId() {
        return this.templateId;
    }

    public int getTemplateVersion() {
        return this.templateVersion;
    }

    public String getTemplateUri() {
        return this.templateUri;
    }

    public String getBody() {
        return this.body;
    }

    public String getSubject() {
        return this.subject;
    }

    @Override
    public String toString() {
        return "SendLetterResponse{notificationId=" + this.getNotificationId() + ", reference=" + this.getReference() + ", templateId=" + this.templateId + ", templateVersion=" + this.templateVersion + ", templateUri='" + this.templateUri + '\'' + ", body='" + this.body + '\'' + ", subject='" + this.subject + '}';
    }
}

