/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.service.notify;

import java.util.Optional;
import java.util.UUID;
import org.json.JSONObject;

public class LetterResponse {
    private final UUID notificationId;
    private final String reference;
    private final String postage;
    private final JSONObject data;

    public LetterResponse(String response) {
        this.data = new JSONObject(response);
        this.notificationId = UUID.fromString(this.data.getString("id"));
        this.reference = this.data.isNull("reference") ? null : this.data.getString("reference");
        this.postage = this.data.isNull("postage") ? null : this.data.getString("postage");
    }

    public UUID getNotificationId() {
        return this.notificationId;
    }

    public Optional<String> getReference() {
        return Optional.ofNullable(this.reference);
    }

    public JSONObject getData() {
        return this.data;
    }

    public Optional<String> getPostage() {
        return Optional.ofNullable(this.postage);
    }

    public String toString() {
        return "SendLetterResponse{notificationId=" + this.notificationId + ", reference=" + this.reference + '}';
    }

    public String tryToGetString(JSONObject jsonObj, String key) {
        if (jsonObj.has(key)) {
            if (jsonObj.opt(key).toString().equals("null")) {
                return null;
            }
            return jsonObj.opt(key).toString();
        }
        return null;
    }
}

