/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.service.notify;

import java.util.Optional;
import java.util.UUID;
import org.joda.time.DateTime;
import org.json.JSONObject;

public class Notification {
    private UUID id;
    private String reference;
    private String emailAddress;
    private String phoneNumber;
    private String line1;
    private String line2;
    private String line3;
    private String line4;
    private String line5;
    private String line6;
    private String postcode;
    private String notificationType;
    private String status;
    private UUID templateId;
    private int templateVersion;
    private String templateUri;
    private String body;
    private String subject;
    private DateTime createdAt;
    private DateTime sentAt;
    private DateTime completedAt;
    private DateTime estimatedDelivery;

    public Notification(String content) {
        JSONObject responseBodyAsJson = new JSONObject(content);
        this.build(responseBodyAsJson);
    }

    public Notification(JSONObject data) {
        this.build(data);
    }

    private void build(JSONObject data) {
        this.id = UUID.fromString(data.getString("id"));
        this.reference = data.isNull("reference") ? null : data.getString("reference");
        this.emailAddress = data.isNull("email_address") ? null : data.getString("email_address");
        this.phoneNumber = data.isNull("phone_number") ? null : data.getString("phone_number");
        this.line1 = data.isNull("line_1") ? null : data.getString("line_1");
        this.line2 = data.isNull("line_2") ? null : data.getString("line_2");
        this.line3 = data.isNull("line_3") ? null : data.getString("line_3");
        this.line4 = data.isNull("line_4") ? null : data.getString("line_4");
        this.line5 = data.isNull("line_5") ? null : data.getString("line_5");
        this.line6 = data.isNull("line_6") ? null : data.getString("line_6");
        this.postcode = data.isNull("postcode") ? null : data.getString("postcode");
        this.notificationType = data.getString("type");
        JSONObject template = data.getJSONObject("template");
        this.templateId = UUID.fromString(template.getString("id"));
        this.templateVersion = template.getInt("version");
        this.templateUri = template.getString("uri");
        this.body = data.getString("body");
        this.subject = data.isNull("subject") ? null : data.getString("subject");
        this.status = data.getString("status");
        this.createdAt = new DateTime((Object)data.getString("created_at"));
        this.sentAt = data.isNull("sent_at") ? null : new DateTime((Object)data.getString("sent_at"));
        this.completedAt = data.isNull("completed_at") ? null : new DateTime((Object)data.getString("completed_at"));
        this.estimatedDelivery = data.isNull("estimated_delivery") ? null : new DateTime((Object)data.getString("estimated_delivery"));
    }

    public UUID getId() {
        return this.id;
    }

    public Optional<String> getReference() {
        return Optional.ofNullable(this.reference);
    }

    public Optional<String> getEmailAddress() {
        return Optional.ofNullable(this.emailAddress);
    }

    public Optional<String> getPhoneNumber() {
        return Optional.ofNullable(this.phoneNumber);
    }

    public Optional<String> getLine1() {
        return Optional.ofNullable(this.line1);
    }

    public Optional<String> getLine2() {
        return Optional.ofNullable(this.line2);
    }

    public Optional<String> getLine3() {
        return Optional.ofNullable(this.line3);
    }

    public Optional<String> getLine4() {
        return Optional.ofNullable(this.line4);
    }

    public Optional<String> getLine5() {
        return Optional.ofNullable(this.line5);
    }

    public Optional<String> getLine6() {
        return Optional.ofNullable(this.line6);
    }

    public Optional<String> getPostcode() {
        return Optional.ofNullable(this.postcode);
    }

    public String getNotificationType() {
        return this.notificationType;
    }

    public String getStatus() {
        return this.status;
    }

    public UUID getTemplateId() {
        return this.templateId;
    }

    public int getTemplateVersion() {
        return this.templateVersion;
    }

    public String getTemplateUri() {
        return this.templateUri;
    }

    public String getBody() {
        return this.body;
    }

    public Optional<String> getSubject() {
        return Optional.ofNullable(this.subject);
    }

    public DateTime getCreatedAt() {
        return this.createdAt;
    }

    public Optional<DateTime> getSentAt() {
        return Optional.ofNullable(this.sentAt);
    }

    public Optional<DateTime> getCompletedAt() {
        return Optional.ofNullable(this.completedAt);
    }

    public Optional<DateTime> getEstimatedDelivery() {
        return Optional.ofNullable(this.estimatedDelivery);
    }

    public String toString() {
        return "Notification{id=" + this.id + ", reference='" + this.reference + '\'' + ", emailAddress='" + this.emailAddress + '\'' + ", phoneNumber='" + this.phoneNumber + '\'' + ", line1='" + this.line1 + '\'' + ", line2='" + this.line2 + '\'' + ", line3='" + this.line3 + '\'' + ", line4='" + this.line4 + '\'' + ", line5='" + this.line5 + '\'' + ", line6='" + this.line6 + '\'' + ", postcode='" + this.postcode + '\'' + ", notificationType='" + this.notificationType + '\'' + ", status='" + this.status + '\'' + ", templateId=" + this.templateId + ", templateVersion=" + this.templateVersion + ", templateUri='" + this.templateUri + '\'' + ", body='" + this.body + '\'' + ", subject='" + this.subject + '\'' + ", createdAt=" + this.createdAt + ", sentAt=" + this.sentAt + ", completedAt=" + this.completedAt + ", estimatedDelivery=" + this.estimatedDelivery + '}';
    }
}

