/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.service.notify;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.NoSuchAlgorithmException;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import org.apache.http.client.utils.URIBuilder;
import org.json.JSONObject;
import uk.gov.service.notify.Authentication;
import uk.gov.service.notify.Notification;
import uk.gov.service.notify.NotificationClientApi;
import uk.gov.service.notify.NotificationClientException;
import uk.gov.service.notify.NotificationList;
import uk.gov.service.notify.ReceivedTextMessageList;
import uk.gov.service.notify.SendEmailResponse;
import uk.gov.service.notify.SendLetterResponse;
import uk.gov.service.notify.SendSmsResponse;
import uk.gov.service.notify.Template;
import uk.gov.service.notify.TemplateList;
import uk.gov.service.notify.TemplatePreview;

public class NotificationClient
implements NotificationClientApi {
    private static final Logger LOGGER = Logger.getLogger(NotificationClient.class.toString());
    public static final String LIVE_BASE_URL = "https://api.notifications.service.gov.uk";
    private final String apiKey;
    private final String serviceId;
    private final String baseUrl;
    private final Proxy proxy;
    private final String version;

    public NotificationClient(String apiKey) {
        this(apiKey, LIVE_BASE_URL, null);
    }

    public NotificationClient(String apiKey, Proxy proxy) {
        this(apiKey, LIVE_BASE_URL, proxy);
    }

    public NotificationClient(String apiKey, String baseUrl) {
        this(apiKey, baseUrl, null);
    }

    public NotificationClient(String apiKey, String baseUrl, Proxy proxy) {
        this(apiKey, baseUrl, proxy, null);
        try {
            NotificationClient.setDefaultSSLContext();
        }
        catch (NoSuchAlgorithmException e) {
            LOGGER.log(Level.SEVERE, e.toString(), e);
        }
    }

    public NotificationClient(String apiKey, String baseUrl, Proxy proxy, SSLContext sslContext) {
        this.apiKey = NotificationClient.extractApiKey(apiKey);
        this.serviceId = NotificationClient.extractServiceId(apiKey);
        this.baseUrl = baseUrl;
        this.proxy = proxy;
        if (sslContext != null) {
            try {
                NotificationClient.setCustomSSLContext(sslContext);
            }
            catch (NoSuchAlgorithmException e) {
                LOGGER.log(Level.SEVERE, e.toString(), e);
            }
        }
        this.version = this.getVersion();
    }

    public String getUserAgent() {
        return "NOTIFY-API-JAVA-CLIENT/" + this.version;
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public String getServiceId() {
        return this.serviceId;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public Proxy getProxy() {
        return this.proxy;
    }

    @Override
    public SendEmailResponse sendEmail(String templateId, String emailAddress, Map<String, String> personalisation, String reference) throws NotificationClientException {
        return this.sendEmail(templateId, emailAddress, personalisation, reference, "");
    }

    @Override
    public SendEmailResponse sendEmail(String templateId, String emailAddress, Map<String, String> personalisation, String reference, String emailReplyToId) throws NotificationClientException {
        JSONObject body = this.createBodyForPostRequest(templateId, null, emailAddress, personalisation, reference);
        if (emailReplyToId != null && !emailReplyToId.isEmpty()) {
            body.put("email_reply_to_id", (Object)emailReplyToId);
        }
        HttpURLConnection conn = this.createConnectionAndSetHeaders(this.baseUrl + "/v2/notifications/email", "POST");
        String response = this.performPostRequest(conn, body, 201);
        return new SendEmailResponse(response);
    }

    @Override
    public SendSmsResponse sendSms(String templateId, String phoneNumber, Map<String, String> personalisation, String reference) throws NotificationClientException {
        return this.sendSms(templateId, phoneNumber, personalisation, reference, "");
    }

    @Override
    public SendSmsResponse sendSms(String templateId, String phoneNumber, Map<String, String> personalisation, String reference, String smsSenderId) throws NotificationClientException {
        JSONObject body = this.createBodyForPostRequest(templateId, phoneNumber, null, personalisation, reference);
        if (smsSenderId != null && !smsSenderId.isEmpty()) {
            body.put("sms_sender_id", (Object)smsSenderId);
        }
        HttpURLConnection conn = this.createConnectionAndSetHeaders(this.baseUrl + "/v2/notifications/sms", "POST");
        String response = this.performPostRequest(conn, body, 201);
        return new SendSmsResponse(response);
    }

    @Override
    public SendLetterResponse sendLetter(String templateId, Map<String, String> personalisation, String reference) throws NotificationClientException {
        JSONObject body = this.createBodyForPostRequest(templateId, null, null, personalisation, reference);
        HttpURLConnection conn = this.createConnectionAndSetHeaders(this.baseUrl + "/v2/notifications/letter", "POST");
        String response = this.performPostRequest(conn, body, 201);
        return new SendLetterResponse(response);
    }

    @Override
    public Notification getNotificationById(String notificationId) throws NotificationClientException {
        String url = this.baseUrl + "/v2/notifications/" + notificationId;
        HttpURLConnection conn = this.createConnectionAndSetHeaders(url, "GET");
        String response = this.performGetRequest(conn);
        return new Notification(response);
    }

    @Override
    public NotificationList getNotifications(String status, String notification_type, String reference, String olderThanId) throws NotificationClientException {
        try {
            URIBuilder builder = new URIBuilder(this.baseUrl + "/v2/notifications");
            if (status != null && !status.isEmpty()) {
                builder.addParameter("status", status);
            }
            if (notification_type != null && !notification_type.isEmpty()) {
                builder.addParameter("template_type", notification_type);
            }
            if (reference != null && !reference.isEmpty()) {
                builder.addParameter("reference", reference);
            }
            if (olderThanId != null && !olderThanId.isEmpty()) {
                builder.addParameter("older_than", olderThanId);
            }
            HttpURLConnection conn = this.createConnectionAndSetHeaders(builder.toString(), "GET");
            String response = this.performGetRequest(conn);
            return new NotificationList(response);
        }
        catch (URISyntaxException e) {
            LOGGER.log(Level.SEVERE, e.toString(), e);
            throw new NotificationClientException(e);
        }
    }

    @Override
    public Template getTemplateById(String templateId) throws NotificationClientException {
        String url = this.baseUrl + "/v2/template/" + templateId;
        HttpURLConnection conn = this.createConnectionAndSetHeaders(url, "GET");
        String response = this.performGetRequest(conn);
        return new Template(response);
    }

    @Override
    public Template getTemplateVersion(String templateId, int version) throws NotificationClientException {
        String url = this.baseUrl + "/v2/template/" + templateId + "/version/" + version;
        HttpURLConnection conn = this.createConnectionAndSetHeaders(url, "GET");
        String response = this.performGetRequest(conn);
        return new Template(response);
    }

    @Override
    public TemplateList getAllTemplates(String templateType) throws NotificationClientException {
        try {
            URIBuilder builder = new URIBuilder(this.baseUrl + "/v2/templates");
            if (templateType != null && !templateType.isEmpty()) {
                builder.addParameter("type", templateType);
            }
            HttpURLConnection conn = this.createConnectionAndSetHeaders(builder.toString(), "GET");
            String response = this.performGetRequest(conn);
            return new TemplateList(response);
        }
        catch (URISyntaxException e) {
            LOGGER.log(Level.SEVERE, e.toString(), e);
            throw new NotificationClientException(e);
        }
    }

    @Override
    public TemplatePreview generateTemplatePreview(String templateId, Map<String, String> personalisation) throws NotificationClientException {
        JSONObject body = new JSONObject();
        if (personalisation != null && !personalisation.isEmpty()) {
            body.put("personalisation", (Object)new JSONObject(personalisation));
        }
        HttpURLConnection conn = this.createConnectionAndSetHeaders(this.baseUrl + "/v2/template/" + templateId + "/preview", "POST");
        String response = this.performPostRequest(conn, body, 200);
        return new TemplatePreview(response);
    }

    @Override
    public ReceivedTextMessageList getReceivedTextMessages(String olderThanId) throws NotificationClientException {
        try {
            URIBuilder builder = new URIBuilder(this.baseUrl + "/v2/received-text-messages");
            if (olderThanId != null && !olderThanId.isEmpty()) {
                builder.addParameter("older_than", olderThanId);
            }
            HttpURLConnection conn = this.createConnectionAndSetHeaders(builder.toString(), "GET");
            String response = this.performGetRequest(conn);
            return new ReceivedTextMessageList(response);
        }
        catch (URISyntaxException e) {
            LOGGER.log(Level.SEVERE, e.toString(), e);
            throw new NotificationClientException(e);
        }
    }

    private String performPostRequest(HttpURLConnection conn, JSONObject body, int expectedStatusCode) throws NotificationClientException {
        try {
            OutputStreamWriter wr = new OutputStreamWriter(conn.getOutputStream());
            wr.write(body.toString());
            wr.flush();
            int httpResult = conn.getResponseCode();
            if (httpResult == expectedStatusCode) {
                StringBuilder sb = this.readStream(new InputStreamReader(conn.getInputStream(), "utf-8"));
                String string = sb.toString();
                return string;
            }
            try {
                StringBuilder sb = this.readStream(new InputStreamReader(conn.getErrorStream(), "utf-8"));
                throw new NotificationClientException(httpResult, sb.toString());
            }
            catch (IOException e) {
                LOGGER.log(Level.SEVERE, e.toString(), e);
                throw new NotificationClientException(e);
            }
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
    }

    private String performGetRequest(HttpURLConnection conn) throws NotificationClientException {
        try {
            int httpResult = conn.getResponseCode();
            if (httpResult == 200) {
                StringBuilder stringBuilder = this.readStream(new InputStreamReader(conn.getInputStream()));
                conn.disconnect();
                String string = stringBuilder.toString();
                return string;
            }
            try {
                StringBuilder stringBuilder = this.readStream(new InputStreamReader(conn.getErrorStream(), "utf-8"));
                throw new NotificationClientException(httpResult, stringBuilder.toString());
            }
            catch (IOException e) {
                LOGGER.log(Level.SEVERE, e.toString(), e);
                throw new NotificationClientException(e);
            }
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
    }

    private HttpURLConnection createConnectionAndSetHeaders(String urlString, String method) throws NotificationClientException {
        try {
            URL url = new URL(urlString);
            HttpURLConnection conn = this.getConnection(url);
            conn.setRequestMethod(method);
            Authentication authentication = new Authentication();
            String token = authentication.create(this.serviceId, this.apiKey);
            conn.setRequestProperty("Authorization", "Bearer " + token);
            conn.setRequestProperty("User-agent", this.getUserAgent());
            if (method.equals("POST")) {
                conn.setDoOutput(true);
                conn.setRequestProperty("Content-Type", "application/json");
                conn.setRequestProperty("Accept", "application/json");
            }
            return conn;
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, e.toString(), e);
            throw new NotificationClientException(e);
        }
    }

    private HttpURLConnection getConnection(URL url) throws IOException {
        HttpURLConnection conn = null != this.proxy ? (HttpURLConnection)url.openConnection(this.proxy) : (HttpURLConnection)url.openConnection();
        return conn;
    }

    private JSONObject createBodyForPostRequest(String templateId, String phoneNumber, String emailAddress, Map<String, String> personalisation, String reference) {
        JSONObject body = new JSONObject();
        if (phoneNumber != null && !phoneNumber.isEmpty()) {
            body.put("phone_number", (Object)phoneNumber);
        }
        if (emailAddress != null && !emailAddress.isEmpty()) {
            body.put("email_address", (Object)emailAddress);
        }
        body.put("template_id", (Object)templateId);
        if (personalisation != null && !personalisation.isEmpty()) {
            body.put("personalisation", (Object)new JSONObject(personalisation));
        }
        if (reference != null && !reference.isEmpty()) {
            body.put("reference", (Object)reference);
        }
        return body;
    }

    private StringBuilder readStream(InputStreamReader streamReader) throws IOException {
        StringBuilder sb = new StringBuilder();
        BufferedReader br = new BufferedReader(streamReader);
        String line = null;
        while ((line = br.readLine()) != null) {
            sb.append(line + "\n");
        }
        br.close();
        return sb;
    }

    private static void setDefaultSSLContext() throws NoSuchAlgorithmException {
        HttpsURLConnection.setDefaultSSLSocketFactory(SSLContext.getDefault().getSocketFactory());
    }

    private static void setCustomSSLContext(SSLContext sslContext) throws NoSuchAlgorithmException {
        HttpsURLConnection.setDefaultSSLSocketFactory(sslContext.getSocketFactory());
    }

    private static String extractServiceId(String apiKey) {
        return apiKey.substring(Math.max(0, apiKey.length() - 73), Math.max(0, apiKey.length() - 37));
    }

    private static String extractApiKey(String apiKey) {
        return apiKey.substring(Math.max(0, apiKey.length() - 36));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getVersion() {
        InputStream input = null;
        Properties prop = new Properties();
        try {
            input = this.getClass().getClassLoader().getResourceAsStream("application.properties");
            prop.load(input);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        finally {
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return prop.getProperty("project.version");
    }
}

