/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.service.notify;

import java.io.UnsupportedEncodingException;
import java.security.Key;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.jose4j.jws.JsonWebSignature;
import org.jose4j.jwt.JwtClaims;
import org.jose4j.lang.JoseException;

public final class Authentication {
    public static final String ENCODING = "UTF-8";

    public String create(String issuer, String secret) {
        try {
            JsonWebSignature jws = new JsonWebSignature();
            jws.setAlgorithmHeaderValue("HS256");
            jws.setHeader("typ", "JWT");
            JwtClaims claims = new JwtClaims();
            claims.setIssuer(issuer);
            claims.setIssuedAtToNow();
            jws.setPayload(claims.toJson());
            jws.setKey((Key)Authentication.keyFromString(secret));
            return jws.getCompactSerialization();
        }
        catch (UnsupportedEncodingException | JoseException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static SecretKey keyFromString(String value) throws UnsupportedEncodingException {
        return new SecretKeySpec(value.getBytes(ENCODING), "RAW");
    }
}

