/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.service.notify;

import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import org.joda.time.DateTime;
import org.json.JSONObject;
import uk.gov.service.notify.JsonUtils;

public class Template {
    private UUID id;
    private String name;
    private String templateType;
    private DateTime createdAt;
    private DateTime updatedAt;
    private String createdBy;
    private int version;
    private String body;
    private String subject;
    private Map<String, Object> personalisation;
    private String letterContactBlock;

    public Template(String content) {
        JSONObject responseBodyAsJson = new JSONObject(content);
        this.build(responseBodyAsJson);
    }

    public Template(JSONObject data) {
        this.build(data);
    }

    private void build(JSONObject data) {
        this.id = UUID.fromString(data.getString("id"));
        this.name = data.getString("name");
        this.templateType = data.getString("type");
        this.createdAt = new DateTime((Object)data.getString("created_at"));
        this.updatedAt = data.isNull("updated_at") ? null : new DateTime((Object)data.getString("updated_at"));
        this.version = data.getInt("version");
        this.body = data.getString("body");
        this.subject = data.isNull("subject") ? null : data.getString("subject");
        this.letterContactBlock = data.isNull("letter_contact_block") ? null : data.getString("letter_contact_block");
        this.personalisation = data.isNull("personalisation") ? null : JsonUtils.jsonToMap(data.getJSONObject("personalisation"));
    }

    public UUID getId() {
        return this.id;
    }

    public void setId(UUID id) {
        this.id = id;
    }

    public String getTemplateType() {
        return this.templateType;
    }

    public void setTemplateType(String templateType) {
        this.templateType = templateType;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public DateTime getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(DateTime createdAt) {
        this.createdAt = createdAt;
    }

    public Optional<DateTime> getUpdatedAt() {
        return Optional.ofNullable(this.updatedAt);
    }

    public void setUpdatedAt(DateTime updatedAt) {
        this.updatedAt = updatedAt;
    }

    public String getCreatedBy() {
        return this.createdBy;
    }

    public void setCreatedBy(String createdBy) {
        this.createdBy = createdBy;
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public String getBody() {
        return this.body;
    }

    public void setBody(String body) {
        this.body = body;
    }

    public Optional<String> getSubject() {
        return Optional.ofNullable(this.subject);
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public Optional<String> getLetterContactBlock() {
        return Optional.ofNullable(this.letterContactBlock);
    }

    public void setLetterContactBlock(String letterContactBlock) {
        this.letterContactBlock = letterContactBlock;
    }

    public Optional<Map<String, Object>> getPersonalisation() {
        return Optional.ofNullable(this.personalisation);
    }

    public void setPersonalisation(Map<String, Object> personalisation) {
        this.personalisation = personalisation;
    }

    public String toString() {
        return "Template{id=" + this.id + ", templateType='" + this.templateType + '\'' + ", createdAt=" + this.createdAt + ", updatedAt=" + this.updatedAt + ", createdBy='" + this.createdBy + '\'' + ", version=" + this.version + ", body='" + this.body + '\'' + ", subject='" + this.subject + '\'' + ", letterContactBlock='" + this.letterContactBlock + '\'' + ", personalisation='" + this.personalisation + '\'' + '}';
    }
}

