/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.ida;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.java.archives.Attributes;
import org.gradle.api.java.archives.Manifest;

public class IdaJarPlugin
implements Plugin<Project> {
    public void apply(Project project) {
        Action<Task> action = new Action<Task>(){

            public void execute(Task task) {
                Project project = task.getProject();
                if (project.hasProperty("mainclass")) {
                    Manifest manifest = (Manifest)task.property("manifest");
                    Attributes attributes = manifest.getAttributes();
                    attributes.put((Object)"Main-Class", project.property("mainclass"));
                    StringBuilder sb = new StringBuilder();
                    for (File part : project.getConfigurations().getByName("runtime").getFiles()) {
                        sb.append("lib/");
                        sb.append(part.getName());
                        sb.append(" ");
                    }
                    attributes.put((Object)"Class-Path", (Object)sb.toString());
                    String build_number = System.getenv("BUILD_NUMBER");
                    String git_commit = System.getenv("GIT_COMMIT");
                    String version_number = project.property("version").toString();
                    attributes.put((Object)"Build-Number", (Object)(build_number != null ? build_number : ""));
                    attributes.put((Object)"Version-Number", (Object)(version_number != null ? version_number : ""));
                    attributes.put((Object)"Git-Commit", (Object)(git_commit != null ? git_commit : ""));
                    TimeZone utcTimeZone = TimeZone.getTimeZone("UTC");
                    SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm'Z'");
                    dateFormat.setTimeZone(utcTimeZone);
                    String isoFormat = dateFormat.format(new Date());
                    attributes.put((Object)"Build-Timestamp", (Object)isoFormat);
                    task.setProperty("archiveName", (Object)(task.property("baseName") + ".jar"));
                    task.setProperty("destinationDir", (Object)new File(project.getBuildDir(), "output"));
                }
            }
        };
        project.getTasks().getByName("jar").doFirst((Action)action);
    }
}

