/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.ida.eventemitter.sqs;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.sqs.AmazonSQS;
import com.amazonaws.services.sqs.model.SendMessageRequest;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.joda.JodaModule;
import com.google.inject.Inject;
import javax.inject.Named;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.gov.ida.eventemitter.AuditEvent;
import uk.gov.ida.eventemitter.sqs.SqsClient;

public class AmazonSqsClient
implements SqsClient {
    private static final Logger LOG = LoggerFactory.getLogger(AmazonSqsClient.class);
    private final AmazonSQS sqs;
    private final String queueUrl;
    private final ObjectMapper objectMapper;

    @Inject
    public AmazonSqsClient(AmazonSQS sqs, @Named(value="QueueUrl") String queueUrl, ObjectMapper objectMapper) {
        this.sqs = sqs;
        this.queueUrl = queueUrl;
        this.objectMapper = objectMapper.registerModule((Module)new JodaModule());
    }

    @Override
    public void send(AuditEvent event) throws AmazonClientException {
        try {
            SendMessageRequest sendMessageRequest = new SendMessageRequest(this.queueUrl, this.objectMapper.writeValueAsString((Object)event));
            this.sqs.sendMessage(sendMessageRequest);
            LOG.info(String.format("Sent a message [Event Id: %s] to the queue successfully. [%s]", event.getEventId(), event.getLoggableMessage()));
        }
        catch (JsonProcessingException e) {
            LOG.error(String.format("Unable to convert [Event Id: %s] to json. Message not sent to the queue. [%s]", event.getEventId(), event.getLoggableMessage()));
        }
    }
}

