/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.ida.eventemitter;

import java.util.EnumMap;
import java.util.UUID;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import uk.gov.ida.eventemitter.EventDetailsKey;
import uk.gov.ida.eventemitter.EventMessage;

public final class EventMessageBuilder {
    private UUID eventId = UUID.fromString("7d20e892-2f01-4abc-b575-77b9f93c316f");
    private DateTime timestamp = DateTime.now().withZone(DateTimeZone.UTC);
    private String eventType = "session_event";
    private String originatingService = "test";
    private String sessionId = "f81176c8-24f7-4622-ac61-7ebbc978bcdb";
    private EnumMap<EventDetailsKey, String> details = new EnumMap(EventDetailsKey.class);

    public EventMessageBuilder() {
        this.details.put(EventDetailsKey.message, "Session error");
        this.details.put(EventDetailsKey.error_id, "7d20e892-2f01-4abc-b575-77b9f93c316z");
    }

    public static EventMessageBuilder anEventMessage() {
        return new EventMessageBuilder();
    }

    public EventMessage build() {
        return new EventMessage(this.eventId, this.timestamp, this.eventType, this.originatingService, this.sessionId, this.details);
    }

    public EventMessageBuilder withEventId(UUID eventId) {
        this.eventId = eventId;
        return this;
    }

    public EventMessageBuilder withTimestamp(DateTime timestamp) {
        this.timestamp = timestamp;
        return this;
    }

    public EventMessageBuilder withOriginatingService(String originatingService) {
        this.originatingService = originatingService;
        return this;
    }

    public EventMessageBuilder withSessionId(String sessionId) {
        this.sessionId = sessionId;
        return this;
    }

    public EventMessageBuilder withDetails(EnumMap<EventDetailsKey, String> details) {
        this.details = details;
        return this;
    }

    public EventMessageBuilder withDetailsField(EventDetailsKey key, String value) {
        this.details.put(key, value);
        return this;
    }

    public EventMessageBuilder withEventType(String eventType) {
        this.eventType = eventType;
        return this;
    }
}

