/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.ida.eventemitter;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.EnumMap;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.concurrent.Immutable;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import uk.gov.ida.eventemitter.Event;
import uk.gov.ida.eventemitter.EventDetailsKey;

@Immutable
public final class EventMessage
implements Event {
    @JsonProperty
    private UUID eventId;
    @JsonProperty
    private DateTime timestamp;
    @JsonProperty
    private String eventType;
    @JsonProperty
    private String originatingService;
    @JsonProperty
    private String sessionId;
    @JsonProperty
    private EnumMap<EventDetailsKey, String> details;

    private EventMessage() {
    }

    public EventMessage(UUID eventId, DateTime timestamp, String eventType, String originatingService, String sessionId, EnumMap<EventDetailsKey, String> details) {
        this.eventId = eventId;
        this.timestamp = timestamp;
        this.originatingService = originatingService;
        this.sessionId = sessionId;
        this.eventType = eventType;
        this.details = details;
    }

    public EventMessage(String originatingService, String sessionId, String eventType, EnumMap<EventDetailsKey, String> details) {
        this(UUID.randomUUID(), DateTime.now((DateTimeZone)DateTimeZone.UTC), originatingService, sessionId, eventType, details);
    }

    @Override
    public UUID getEventId() {
        return this.eventId;
    }

    @Override
    public DateTime getTimestamp() {
        return this.timestamp;
    }

    @Override
    public String getEventType() {
        return this.eventType;
    }

    @Override
    public String getOriginatingService() {
        return this.originatingService;
    }

    @Override
    public String getSessionId() {
        return this.sessionId;
    }

    @Override
    public EnumMap<EventDetailsKey, String> getDetails() {
        return this.details;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Event{");
        sb.append("eventId=").append(this.eventId);
        sb.append(", timestamp=").append(this.timestamp);
        sb.append(", eventType='").append(this.eventType).append('\'');
        sb.append(", originatingService='").append(this.originatingService).append('\'');
        sb.append(", sessionId='").append(this.sessionId).append('\'');
        sb.append(", details=").append(this.details);
        sb.append('}');
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EventMessage event = (EventMessage)o;
        return Objects.equals(this.eventId, event.eventId) && Objects.equals(this.timestamp, event.timestamp) && Objects.equals(this.eventType, event.eventType) && Objects.equals(this.originatingService, event.originatingService) && Objects.equals(this.sessionId, event.sessionId) && Objects.equals(this.details, event.details);
    }

    public int hashCode() {
        return Objects.hash(this.eventId, this.timestamp, this.eventType, this.originatingService, this.sessionId, this.details);
    }
}

