/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.ida.eventemitter;

import com.fasterxml.jackson.databind.ObjectMapper;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.gov.ida.eventemitter.AwsResponseException;
import uk.gov.ida.eventemitter.Encrypter;
import uk.gov.ida.eventemitter.Event;
import uk.gov.ida.eventemitter.EventHasher;
import uk.gov.ida.eventemitter.EventSender;

public class EventEmitter {
    private static final Logger LOG = LoggerFactory.getLogger(EventEmitter.class);
    private final ObjectMapper objectMapper;
    private final EventHasher eventHasher;
    private final Encrypter encrypter;
    private final EventSender eventSender;

    @Inject
    public EventEmitter(ObjectMapper objectMapper, EventHasher eventHasher, Encrypter encrypter, EventSender eventSender) {
        this.objectMapper = objectMapper;
        this.eventHasher = eventHasher;
        this.encrypter = encrypter;
        this.eventSender = eventSender;
    }

    public void record(Event event) {
        if (event != null) {
            String encryptedEvent = null;
            try {
                LOG.info(this.objectMapper.writeValueAsString((Object)event));
                Event hashedEvent = this.eventHasher.replacePersistentIdWithHashedPersistentId(event);
                encryptedEvent = this.encrypter.encrypt(hashedEvent);
                this.eventSender.sendAuthenticated(hashedEvent, encryptedEvent);
                LOG.info(String.format("Sent Event Message [Event Id: %s]", event.getEventId()));
            }
            catch (AwsResponseException awsEx) {
                LOG.error(String.format("Failed to send a message [Event Id: %s] to the api gateway. Status: %s Error Message: %s Event Detail: %s", event.getEventId(), awsEx.getResponse().getStatusCode(), awsEx.getMessage(), encryptedEvent));
            }
            catch (Exception ex) {
                LOG.error(String.format("Failed to send a message [Event Id: %s] to the api gateway. Error Message: %s Event Detail: %s", event.getEventId(), ex.getMessage(), encryptedEvent));
            }
        } else {
            LOG.error("Unable to send a message due to event containing null value.");
        }
    }
}

