/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.ida.eventemitter.sqs;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.services.sqs.AmazonSQS;
import com.amazonaws.services.sqs.AmazonSQSClientBuilder;
import com.amazonaws.services.sqs.model.GetQueueUrlRequest;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.inject.AbstractModule;
import com.google.inject.Provides;
import javax.annotation.Nullable;
import javax.inject.Named;
import javax.inject.Singleton;
import uk.gov.ida.eventemitter.Configuration;
import uk.gov.ida.eventemitter.sqs.AmazonSqsClient;
import uk.gov.ida.eventemitter.sqs.EventEmitterSQS;
import uk.gov.ida.eventemitter.sqs.SqsClient;
import uk.gov.ida.eventemitter.sqs.StubSqsClient;

public class EventEmitterSQSModule
extends AbstractModule {
    protected void configure() {
    }

    @Provides
    @Singleton
    @Nullable
    private AWSCredentials getAmazonCredential(Configuration configuration) {
        if (configuration.isEnabled()) {
            return new BasicAWSCredentials(configuration.getAccessKeyId(), configuration.getSecretAccessKey());
        }
        return null;
    }

    @Provides
    @Singleton
    private EventEmitterSQS getEventEmitter(SqsClient sqsClient) {
        return new EventEmitterSQS(sqsClient);
    }

    @Provides
    @Singleton
    private SqsClient getAmazonSqsClient(@Nullable AmazonSQS amazonSqs, @Named(value="SourceQueueUrl") String sourceQueueUrl, Configuration configuration, ObjectMapper objectMapper) {
        if (configuration.isEnabled()) {
            return new AmazonSqsClient(amazonSqs, sourceQueueUrl, objectMapper);
        }
        return new StubSqsClient();
    }

    @Provides
    @Singleton
    @Nullable
    private AmazonSQS getAmazonSqs(Configuration configuration, @Nullable AWSCredentials credentials) {
        if (configuration.isEnabled()) {
            return (AmazonSQS)((AmazonSQSClientBuilder)((AmazonSQSClientBuilder)AmazonSQSClientBuilder.standard().withCredentials((AWSCredentialsProvider)new AWSStaticCredentialsProvider(credentials))).withRegion(configuration.getRegion())).build();
        }
        return null;
    }

    @Provides
    @Singleton
    @Nullable
    @Named(value="SourceQueueUrl")
    private String getQueueUrl(@Nullable AmazonSQS amazonSqs, Configuration configuration) {
        if (configuration.isEnabled()) {
            GetQueueUrlRequest queueUrlRequest = new GetQueueUrlRequest(configuration.getSourceQueueName());
            return amazonSqs.getQueueUrl(queueUrlRequest).getQueueUrl();
        }
        return "";
    }
}

