/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.ida.eventemitter;

import com.google.inject.Inject;
import java.util.EnumMap;
import uk.gov.ida.eventemitter.Event;
import uk.gov.ida.eventemitter.EventDetailsKey;
import uk.gov.ida.eventemitter.EventMessage;
import uk.gov.ida.eventemitter.Sha256Util;

public class EventHasher {
    public static final String PID_REMOVED = "Plaintext pid has been removed.";
    private final Sha256Util sha256Util;

    @Inject
    public EventHasher(Sha256Util sha256Util) {
        this.sha256Util = sha256Util;
    }

    public Event replacePersistentIdWithHashedPersistentId(Event event) {
        String pid;
        EnumMap<EventDetailsKey, String> details = event.getDetails();
        if (details != null && (pid = details.get((Object)EventDetailsKey.pid)) != null) {
            String idpEntityId = details.get((Object)EventDetailsKey.idp_entity_id);
            EnumMap<EventDetailsKey, String> newDetails = new EnumMap<EventDetailsKey, String>(EventDetailsKey.class);
            if (idpEntityId == null) {
                newDetails.put(EventDetailsKey.pid, PID_REMOVED);
            } else {
                String hashedPid = this.sha256Util.hash(idpEntityId, pid);
                newDetails.put(EventDetailsKey.pid, hashedPid);
            }
            for (EventDetailsKey e : details.keySet()) {
                if (e == EventDetailsKey.pid) continue;
                newDetails.put(e, details.get((Object)e));
            }
            return new EventMessage(event.getEventId(), event.getTimestamp(), event.getEventType(), event.getOriginatingService(), event.getSessionId(), newDetails);
        }
        return event;
    }
}

