/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.ida.eventemitter;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.joda.JodaModule;
import com.google.inject.Inject;
import java.security.Key;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;
import uk.gov.ida.eventemitter.Encrypter;
import uk.gov.ida.eventemitter.Event;
import uk.gov.ida.eventemitter.EventEncryptionException;

public class EventEncrypter
implements Encrypter {
    public static final int INITIALISATION_VECTOR_SIZE = 16;
    private final byte[] key;
    private final ObjectMapper mapper = new ObjectMapper().registerModule((Module)new JodaModule());

    @Inject
    public EventEncrypter(byte[] key) {
        this.key = key;
    }

    @Override
    public String encrypt(Event event) throws EventEncryptionException {
        try {
            byte[] initialisationVector = this.generateInitialisationVector();
            byte[] encryptedEvent = this.encryptEvent(event, initialisationVector);
            byte[] encryptedEventAndIv = this.combineEncryptedEventWithIV(encryptedEvent, initialisationVector);
            return Base64.encodeBase64String((byte[])encryptedEventAndIv);
        }
        catch (Exception e) {
            throw new EventEncryptionException(e);
        }
    }

    private byte[] generateInitialisationVector() {
        byte[] initialisationVector = new byte[16];
        SecureRandom random = new SecureRandom();
        random.nextBytes(initialisationVector);
        return initialisationVector;
    }

    private byte[] encryptEvent(Event event, byte[] initialisationVector) throws Exception {
        SecretKeySpec skeySpec = new SecretKeySpec(this.key, "AES");
        Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5PADDING");
        cipher.init(1, (Key)skeySpec, new IvParameterSpec(initialisationVector));
        return cipher.doFinal(this.mapper.writeValueAsBytes((Object)event));
    }

    private byte[] combineEncryptedEventWithIV(byte[] encryptedEvent, byte[] initialisationVector) {
        byte[] encryptedEventAndIv = new byte[16 + encryptedEvent.length];
        System.arraycopy(initialisationVector, 0, encryptedEventAndIv, 0, 16);
        System.arraycopy(encryptedEvent, 0, encryptedEventAndIv, 16, encryptedEvent.length);
        return encryptedEventAndIv;
    }
}

