/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.ida.eventemitter;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.BasicAWSCredentials;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.inject.AbstractModule;
import com.google.inject.Provides;
import javax.annotation.Nullable;
import javax.inject.Named;
import javax.inject.Singleton;
import uk.gov.ida.eventemitter.AmazonEventSender;
import uk.gov.ida.eventemitter.Configuration;
import uk.gov.ida.eventemitter.Encrypter;
import uk.gov.ida.eventemitter.EventEmitter;
import uk.gov.ida.eventemitter.EventEncrypter;
import uk.gov.ida.eventemitter.EventHasher;
import uk.gov.ida.eventemitter.EventSender;
import uk.gov.ida.eventemitter.Sha256Util;
import uk.gov.ida.eventemitter.StubEncrypter;
import uk.gov.ida.eventemitter.StubEventSender;

public class EventEmitterModule
extends AbstractModule {
    protected void configure() {
    }

    @Provides
    @Singleton
    @Nullable
    private AWSCredentials getAmazonCredential(Configuration configuration) {
        if (configuration.isEnabled()) {
            return new BasicAWSCredentials(configuration.getAccessKeyId(), configuration.getSecretAccessKey());
        }
        return null;
    }

    @Provides
    @Nullable
    @Named(value="EncryptionKey")
    private byte[] getEncryptionKey(Configuration configuration) {
        if (configuration.isEnabled()) {
            return configuration.getEncryptionKey();
        }
        return null;
    }

    @Provides
    @Singleton
    private EventSender getEventSender(Configuration configuration, @Nullable AWSCredentials credentials) {
        if (configuration.isEnabled()) {
            return new AmazonEventSender(configuration.getApiGatewayUrl(), credentials, configuration.getRegion());
        }
        return new StubEventSender();
    }

    @Provides
    @Singleton
    private Encrypter getEncrypter(Configuration configuration, @Nullable @Named(value="EncryptionKey") byte[] encryptionKey) {
        if (configuration.isEnabled()) {
            return new EventEncrypter(encryptionKey);
        }
        return new StubEncrypter();
    }

    @Provides
    @Singleton
    private EventEmitter getEventEmitter(ObjectMapper objectMapper, EventSender eventSender, Encrypter encrypter) {
        return new EventEmitter(objectMapper, new EventHasher(new Sha256Util()), encrypter, eventSender);
    }
}

