/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.ida.eventemitter;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.auth.AWS4Signer;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.http.AmazonHttpClient;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.http.HttpResponse;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.regions.Regions;
import com.amazonaws.util.StringInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.util.HashMap;
import uk.gov.ida.eventemitter.AwsResponseException;
import uk.gov.ida.eventemitter.Event;
import uk.gov.ida.eventemitter.EventSender;

public class AmazonEventSender
implements EventSender {
    private static final String SERVICE_NAME = "execute-api";
    private URI apiGatewayUrl;
    private AWSCredentials credentials;
    private Regions region;

    public AmazonEventSender(URI apiGatewayUrl, AWSCredentials credentials, Regions region) {
        this.apiGatewayUrl = apiGatewayUrl;
        this.credentials = credentials;
        this.region = region;
    }

    @Override
    public void sendAuthenticated(Event event, String encryptedEvent) throws AwsResponseException, UnsupportedEncodingException {
        Request<Void> request = this.createRequest(encryptedEvent);
        request = this.signRequest(request);
        new AmazonHttpClient(new ClientConfiguration()).requestExecutionBuilder().executionContext(new ExecutionContext(true)).request(request).errorResponseHandler((HttpResponseHandler)new HttpResponseHandler<AwsResponseException>(){

            public AwsResponseException handle(HttpResponse response) {
                return new AwsResponseException(response);
            }

            public boolean needsConnectionLeftOpen() {
                return false;
            }
        }).execute();
    }

    private Request<Void> signRequest(Request<Void> request) {
        AWS4Signer signer = new AWS4Signer();
        signer.setRegionName(this.region.getName());
        signer.setServiceName(request.getServiceName());
        signer.sign(request, this.credentials);
        return request;
    }

    private Request<Void> createRequest(String encryptedEvent) throws UnsupportedEncodingException {
        DefaultRequest request = new DefaultRequest(SERVICE_NAME);
        HashMap<String, String> headersMap = new HashMap<String, String>();
        headersMap.put("Content-type", "application/json");
        request.setHeaders(headersMap);
        request.setHttpMethod(HttpMethodName.POST);
        request.setEndpoint(this.apiGatewayUrl);
        request.setContent((InputStream)new StringInputStream(encryptedEvent));
        return request;
    }
}

