/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.ida.saml.idp.stub.transformers.outbound;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.opensaml.saml.saml2.core.Assertion;
import org.opensaml.saml.saml2.core.Attribute;
import org.opensaml.saml.saml2.core.AttributeStatement;
import org.opensaml.saml.saml2.core.Issuer;
import uk.gov.ida.saml.core.OpenSamlXmlObjectFactory;
import uk.gov.ida.saml.core.domain.FraudAuthnDetails;
import uk.gov.ida.saml.core.domain.IdentityProviderAssertion;
import uk.gov.ida.saml.core.domain.IdentityProviderAuthnStatement;
import uk.gov.ida.saml.core.domain.IpAddress;
import uk.gov.ida.saml.core.domain.MatchingDataset;
import uk.gov.ida.saml.core.domain.OutboundAssertion;
import uk.gov.ida.saml.core.domain.SimpleMdsValue;
import uk.gov.ida.saml.core.domain.TransliterableMdsValue;
import uk.gov.ida.saml.core.transformers.outbound.OutboundAssertionToSubjectTransformer;
import uk.gov.ida.saml.hub.factories.AttributeFactory;
import uk.gov.ida.saml.idp.stub.transformers.outbound.IdentityProviderAuthnStatementToAuthnStatementTransformer;

public class IdentityProviderAssertionToAssertionTransformer {
    private final OpenSamlXmlObjectFactory openSamlXmlObjectFactory;
    private final AttributeFactory attributeFactory;
    private final IdentityProviderAuthnStatementToAuthnStatementTransformer identityProviderAuthnStatementToAuthnStatementTransformer;
    private final OutboundAssertionToSubjectTransformer outboundAssertionToSubjectTransformer;

    @Inject
    public IdentityProviderAssertionToAssertionTransformer(OpenSamlXmlObjectFactory openSamlXmlObjectFactory, AttributeFactory attributeFactory, IdentityProviderAuthnStatementToAuthnStatementTransformer identityProviderAuthnStatementToAuthnStatementTransformer, OutboundAssertionToSubjectTransformer outboundAssertionToSubjectTransformer) {
        this.openSamlXmlObjectFactory = openSamlXmlObjectFactory;
        this.attributeFactory = attributeFactory;
        this.identityProviderAuthnStatementToAuthnStatementTransformer = identityProviderAuthnStatementToAuthnStatementTransformer;
        this.outboundAssertionToSubjectTransformer = outboundAssertionToSubjectTransformer;
    }

    public Assertion transform(IdentityProviderAssertion identityProviderAssertion) {
        Assertion transformedAssertion = this.openSamlXmlObjectFactory.createAssertion();
        transformedAssertion.setIssueInstant(identityProviderAssertion.getIssueInstant());
        Issuer transformedIssuer = this.openSamlXmlObjectFactory.createIssuer(identityProviderAssertion.getIssuerId());
        transformedAssertion.setIssuer(transformedIssuer);
        transformedAssertion.setID(identityProviderAssertion.getId());
        transformedAssertion.setSubject(this.outboundAssertionToSubjectTransformer.transform((OutboundAssertion)identityProviderAssertion));
        if (identityProviderAssertion.getMatchingDataset().isPresent()) {
            transformedAssertion.getAttributeStatements().add(this.transform((MatchingDataset)identityProviderAssertion.getMatchingDataset().get()));
        }
        if (identityProviderAssertion.getAuthnStatement().isPresent()) {
            IdentityProviderAuthnStatement authnStatement = (IdentityProviderAuthnStatement)identityProviderAssertion.getAuthnStatement().get();
            transformedAssertion.getAuthnStatements().add(this.identityProviderAuthnStatementToAuthnStatementTransformer.transform(authnStatement));
            AttributeStatement attributeStatement = this.openSamlXmlObjectFactory.createAttributeStatement();
            transformedAssertion.getAttributeStatements().add(attributeStatement);
            if (authnStatement.isFraudAuthnStatement()) {
                attributeStatement.getAttributes().addAll(this.createFraudAttributes(authnStatement.getFraudAuthnDetails()));
            }
            attributeStatement.getAttributes().add(this.createIpAddressAttribute(authnStatement.getUserIpAddress()));
        }
        return transformedAssertion;
    }

    private Attribute createIpAddressAttribute(IpAddress userIpAddress) {
        return this.attributeFactory.createUserIpAddressAttribute(userIpAddress.getStringValue());
    }

    private Collection<Attribute> createFraudAttributes(FraudAuthnDetails fraudAuthnDetails) {
        ArrayList<Attribute> attributes = new ArrayList<Attribute>();
        Attribute idpFraudEventId = this.attributeFactory.createIdpFraudEventIdAttribute(fraudAuthnDetails.getEventId());
        attributes.add(idpFraudEventId);
        String indicator = fraudAuthnDetails.getFraudIndicator();
        Attribute fraudIndicator = this.attributeFactory.createGpg45StatusAttribute(indicator);
        attributes.add(fraudIndicator);
        return attributes;
    }

    private AttributeStatement transform(MatchingDataset matchingDataset) {
        AttributeStatement attributeStatement = this.openSamlXmlObjectFactory.createAttributeStatement();
        if (!matchingDataset.getFirstNames().isEmpty()) {
            Attribute firstnameAttribute = this.attributeFactory.createFirstnameAttribute(IdentityProviderAssertionToAssertionTransformer.getSimpleMdsValues(matchingDataset.getFirstNames()));
            attributeStatement.getAttributes().add(firstnameAttribute);
        }
        if (!matchingDataset.getMiddleNames().isEmpty()) {
            Attribute middleNamesAttribute = this.attributeFactory.createMiddlenamesAttribute(matchingDataset.getMiddleNames());
            attributeStatement.getAttributes().add(middleNamesAttribute);
        }
        if (!matchingDataset.getSurnames().isEmpty()) {
            Attribute surnameAttribute = this.attributeFactory.createSurnameAttribute(IdentityProviderAssertionToAssertionTransformer.getSimpleMdsValues(matchingDataset.getSurnames()));
            attributeStatement.getAttributes().add(surnameAttribute);
        }
        if (matchingDataset.getGender().isPresent()) {
            Attribute genderAttribute = this.attributeFactory.createGenderAttribute((SimpleMdsValue)matchingDataset.getGender().get());
            attributeStatement.getAttributes().add(genderAttribute);
        }
        if (!matchingDataset.getDateOfBirths().isEmpty()) {
            Attribute dateOfBirthAttribute = this.attributeFactory.createDateOfBirthAttribute(matchingDataset.getDateOfBirths());
            attributeStatement.getAttributes().add(dateOfBirthAttribute);
        }
        if (matchingDataset.getCurrentAddresses().size() > 0) {
            Attribute currentAddressesAttribute = this.attributeFactory.createCurrentAddressesAttribute(matchingDataset.getCurrentAddresses());
            attributeStatement.getAttributes().add(currentAddressesAttribute);
        }
        if (matchingDataset.getPreviousAddresses().size() > 0) {
            Attribute previousAddressesAttribute = this.attributeFactory.createPreviousAddressesAttribute(matchingDataset.getPreviousAddresses());
            attributeStatement.getAttributes().add(previousAddressesAttribute);
        }
        return attributeStatement;
    }

    private static List<SimpleMdsValue<String>> getSimpleMdsValues(List<TransliterableMdsValue> transliterableMdsValues) {
        return transliterableMdsValues.stream().map(t -> t).collect(Collectors.toList());
    }
}

