/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.ida.saml.idp.stub.transformers.outbound;

import javax.inject.Inject;
import org.joda.time.DateTime;
import org.opensaml.saml.saml2.core.AuthnContext;
import org.opensaml.saml.saml2.core.AuthnStatement;
import uk.gov.ida.saml.core.OpenSamlXmlObjectFactory;
import uk.gov.ida.saml.core.domain.IdentityProviderAuthnStatement;

public class IdentityProviderAuthnStatementToAuthnStatementTransformer {
    private OpenSamlXmlObjectFactory openSamlXmlObjectFactory;

    @Inject
    public IdentityProviderAuthnStatementToAuthnStatementTransformer(OpenSamlXmlObjectFactory openSamlXmlObjectFactory) {
        this.openSamlXmlObjectFactory = openSamlXmlObjectFactory;
    }

    public AuthnStatement transform(IdentityProviderAuthnStatement idaAuthnStatement) {
        AuthnStatement authnStatement = this.openSamlXmlObjectFactory.createAuthnStatement();
        AuthnContext authnContext = this.openSamlXmlObjectFactory.createAuthnContext();
        authnContext.setAuthnContextClassRef(this.openSamlXmlObjectFactory.createAuthnContextClassReference(idaAuthnStatement.getAuthnContext().getUri()));
        authnStatement.setAuthnContext(authnContext);
        authnStatement.setAuthnInstant(DateTime.now());
        return authnStatement;
    }
}

