/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.ida.saml.idp.stub.transformers.inbound;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.joda.time.DateTime;
import org.opensaml.saml.saml2.core.AuthnContextClassRef;
import org.opensaml.saml.saml2.core.AuthnContextComparisonTypeEnumeration;
import org.opensaml.saml.saml2.core.AuthnRequest;
import uk.gov.ida.saml.core.domain.AuthnContext;
import uk.gov.ida.saml.hub.domain.IdaAuthnRequestFromHub;

public class IdaAuthnRequestFromHubUnmarshaller {
    public IdaAuthnRequestFromHub fromSaml(AuthnRequest authnRequest) {
        List authnContextClassRefs = authnRequest.getRequestedAuthnContext().getAuthnContextClassRefs();
        ArrayList<AuthnContext> levelsOfAssurance = new ArrayList<AuthnContext>();
        for (AuthnContextClassRef authnContextClassRef : authnContextClassRefs) {
            levelsOfAssurance.add(this.mapAuthnContextClassReference(authnContextClassRef.getAuthnContextClassRef()));
        }
        Collections.sort(levelsOfAssurance);
        return IdaAuthnRequestFromHub.createRequestReceivedFromHub((String)authnRequest.getID(), (String)authnRequest.getIssuer().getValue(), levelsOfAssurance, (boolean)authnRequest.isForceAuthn(), (DateTime)authnRequest.getConditions().getNotOnOrAfter(), (AuthnContextComparisonTypeEnumeration)authnRequest.getRequestedAuthnContext().getComparison());
    }

    private AuthnContext mapAuthnContextClassReference(String authnContextClassRef) {
        switch (authnContextClassRef) {
            case "urn:uk:gov:cabinet-office:tc:saml:authn-context:level1": {
                return AuthnContext.LEVEL_1;
            }
            case "urn:uk:gov:cabinet-office:tc:saml:authn-context:level2": {
                return AuthnContext.LEVEL_2;
            }
            case "urn:uk:gov:cabinet-office:tc:saml:authn-context:level3": {
                return AuthnContext.LEVEL_3;
            }
            case "urn:uk:gov:cabinet-office:tc:saml:authn-context:level4": {
                return AuthnContext.LEVEL_4;
            }
        }
        throw new IllegalArgumentException("Missing validation on AuthnRequest Level of Assurance");
    }
}

