/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.ida.saml.idp.test.builders;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.joda.time.DateTime;
import org.opensaml.saml.saml2.core.Assertion;
import org.opensaml.saml.saml2.core.EncryptedAssertion;
import org.opensaml.saml.saml2.core.SubjectConfirmationData;
import uk.gov.ida.saml.core.OpenSamlXmlObjectFactory;

public class SubjectConfirmationDataBuilder {
    public static final int NOT_ON_OR_AFTER_DEFAULT_PERIOD = 15;
    private OpenSamlXmlObjectFactory openSamlXmlObjectFactory = new OpenSamlXmlObjectFactory();
    private Optional<String> recipient = Optional.ofNullable("https://signin.service.gov.uk");
    private Optional<DateTime> notOnOrAfter = Optional.ofNullable(DateTime.now().plusMinutes(15));
    private Optional<DateTime> notBefore = Optional.empty();
    private Optional<String> address = Optional.empty();
    private Optional<String> inResponseTo = Optional.ofNullable("_default-request-id_min-20-chars");
    private List<Assertion> assertions = new ArrayList<Assertion>();
    private List<EncryptedAssertion> encryptedAssertions = new ArrayList<EncryptedAssertion>();

    public static SubjectConfirmationDataBuilder aSubjectConfirmationData() {
        return new SubjectConfirmationDataBuilder();
    }

    public SubjectConfirmationData build() {
        SubjectConfirmationData subjectConfirmationData = this.openSamlXmlObjectFactory.createSubjectConfirmationData();
        this.recipient.ifPresent(arg_0 -> ((SubjectConfirmationData)subjectConfirmationData).setRecipient(arg_0));
        this.notOnOrAfter.ifPresent(arg_0 -> ((SubjectConfirmationData)subjectConfirmationData).setNotOnOrAfter(arg_0));
        this.notBefore.ifPresent(arg_0 -> ((SubjectConfirmationData)subjectConfirmationData).setNotBefore(arg_0));
        this.inResponseTo.ifPresent(arg_0 -> ((SubjectConfirmationData)subjectConfirmationData).setInResponseTo(arg_0));
        this.address.ifPresent(arg_0 -> ((SubjectConfirmationData)subjectConfirmationData).setAddress(arg_0));
        subjectConfirmationData.getUnknownXMLObjects().addAll(this.assertions);
        subjectConfirmationData.getUnknownXMLObjects().addAll(this.encryptedAssertions);
        return subjectConfirmationData;
    }

    public SubjectConfirmationDataBuilder withRecipient(String recipient) {
        this.recipient = Optional.ofNullable(recipient);
        return this;
    }

    public SubjectConfirmationDataBuilder withNotOnOrAfter(DateTime notOnOrAfter) {
        this.notOnOrAfter = Optional.ofNullable(notOnOrAfter);
        return this;
    }

    public SubjectConfirmationDataBuilder withNotBefore(DateTime notBefore) {
        this.notBefore = Optional.ofNullable(notBefore);
        return this;
    }

    public SubjectConfirmationDataBuilder withAddress(String address) {
        this.address = Optional.ofNullable(address);
        return this;
    }

    public SubjectConfirmationDataBuilder withInResponseTo(String inResponseTo) {
        this.inResponseTo = Optional.ofNullable(inResponseTo);
        return this;
    }

    public SubjectConfirmationDataBuilder addAssertion(Assertion assertion) {
        this.assertions.add(assertion);
        return this;
    }

    public SubjectConfirmationDataBuilder addAssertions(List<Assertion> assertions) {
        this.assertions.addAll(assertions);
        return this;
    }

    public SubjectConfirmationDataBuilder addAssertion(EncryptedAssertion assertion) {
        this.encryptedAssertions.add(assertion);
        return this;
    }
}

