/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.ida.saml.idp.test.builders;

import java.util.Optional;
import org.opensaml.saml.saml2.core.NameID;
import uk.gov.ida.saml.core.OpenSamlXmlObjectFactory;

public class NameIdBuilder {
    private OpenSamlXmlObjectFactory openSamlXmlObjectFactory = new OpenSamlXmlObjectFactory();
    private String value;
    private Optional<String> format = Optional.ofNullable("urn:oasis:names:tc:SAML:2.0:nameid-format:persistent");
    private Optional<String> nameQualifier = Optional.empty();
    private Optional<String> spNameQualifier = Optional.empty();

    public static NameIdBuilder aNameId() {
        return new NameIdBuilder();
    }

    public NameID build() {
        NameID nameId = this.openSamlXmlObjectFactory.createNameId(this.value);
        nameId.setFormat(null);
        this.format.ifPresent(arg_0 -> ((NameID)nameId).setFormat(arg_0));
        this.nameQualifier.ifPresent(arg_0 -> ((NameID)nameId).setNameQualifier(arg_0));
        this.spNameQualifier.ifPresent(arg_0 -> ((NameID)nameId).setSPNameQualifier(arg_0));
        return nameId;
    }

    public NameIdBuilder withValue(String value) {
        this.value = value;
        return this;
    }

    public NameIdBuilder withFormat(String format) {
        this.format = Optional.ofNullable(format);
        return this;
    }

    public NameIdBuilder withNameQualifier(String nameQualifier) {
        this.nameQualifier = Optional.ofNullable(nameQualifier);
        return this;
    }

    public NameIdBuilder withSpNameQualifier(String spNameQualifier) {
        this.spNameQualifier = Optional.ofNullable(spNameQualifier);
        return this;
    }
}

