/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.ida.saml.idp.test.builders;

import java.util.ArrayList;
import java.util.List;
import org.opensaml.saml.saml2.core.AudienceRestriction;
import org.opensaml.saml.saml2.core.Conditions;
import uk.gov.ida.saml.core.OpenSamlXmlObjectFactory;
import uk.gov.ida.saml.idp.test.builders.AudienceRestrictionBuilder;

public class ConditionsBuilder {
    private OpenSamlXmlObjectFactory openSamlXmlObjectFactory = new OpenSamlXmlObjectFactory();
    private List<AudienceRestriction> audienceRestrictions = new ArrayList<AudienceRestriction>();
    private AudienceRestriction defaultAudienceRestriction = AudienceRestrictionBuilder.anAudienceRestriction().build();
    private boolean shouldIncludeDefaultAudienceRestriction = true;

    public static ConditionsBuilder aConditions() {
        return new ConditionsBuilder();
    }

    public Conditions build() {
        Conditions conditions = this.openSamlXmlObjectFactory.createConditions();
        if (this.shouldIncludeDefaultAudienceRestriction) {
            this.audienceRestrictions.add(this.defaultAudienceRestriction);
        }
        conditions.getAudienceRestrictions().addAll(this.audienceRestrictions);
        return conditions;
    }

    public ConditionsBuilder withoutDefaultAudienceRestriction() {
        this.shouldIncludeDefaultAudienceRestriction = false;
        return this;
    }

    public ConditionsBuilder addAudienceRestriction(AudienceRestriction audienceRestriction) {
        this.shouldIncludeDefaultAudienceRestriction = false;
        this.audienceRestrictions.add(audienceRestriction);
        return this;
    }
}

