/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.ida.common.shared.security;

import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;

public class PrivateKeyFactory {
    public PrivateKey createPrivateKey(byte[] cert) {
        PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(cert);
        try {
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            return keyFactory.generatePrivate(keySpec);
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException rsaE) {
            try {
                KeyFactory keyFactory = KeyFactory.getInstance("EC");
                return keyFactory.generatePrivate(keySpec);
            }
            catch (NoSuchAlgorithmException | InvalidKeySpecException ecE) {
                throw new RuntimeException(rsaE);
            }
        }
    }
}

